/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.trino.util.HashCollisionsEstimator;
import io.trino.util.HashCollisionsSimulator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHashCollisionsEstimator {
    private static final int HASH_TABLE_SIZE = 10000;
    private static final double SIMULATION_ACCURACY = 0.05;
    private static final double EPSILON = 1.0E-4;

    @Test
    public void hashEstimatesShouldIncrease() {
        Assert.assertEquals((Object)HashCollisionsEstimator.estimateNumberOfHashCollisions((int)0, (int)100), (Object)0.0);
        for (int i = 1; i <= 10000; ++i) {
            Assert.assertTrue((HashCollisionsEstimator.estimateNumberOfHashCollisions((int)(i - 1), (int)10000) < HashCollisionsEstimator.estimateNumberOfHashCollisions((int)i, (int)10000) ? 1 : 0) != 0);
        }
    }

    @Test
    public void hashEstimatesShouldScaleLinearly() {
        this.hashEstimatesShouldScaleLinearly(3000, 10000);
        this.hashEstimatesShouldScaleLinearly(5000, 10000);
        this.hashEstimatesShouldScaleLinearly(7500, 10000);
    }

    private void hashEstimatesShouldScaleLinearly(int numberOfValues, int hashTableSize) {
        double unscaledEstimate = HashCollisionsEstimator.estimateNumberOfHashCollisions((int)numberOfValues, (int)hashTableSize);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)1, (Object)3, (Object)4).iterator();
        while (unmodifiableIterator.hasNext()) {
            int exponent = (Integer)unmodifiableIterator.next();
            int scale = (int)Math.pow(10.0, exponent);
            double scaledEstimate = HashCollisionsEstimator.estimateNumberOfHashCollisions((int)(numberOfValues * scale), (int)(hashTableSize * scale));
            Assert.assertEquals((double)(unscaledEstimate * (double)scale), (double)scaledEstimate, (double)1.0E-4);
        }
    }

    @Test(enabled=false)
    public void hashEstimatesShouldApproximateSimulations() {
        this.hashEstimatesShouldApproximateSimulations(1000, 10000);
        this.hashEstimatesShouldApproximateSimulations(1500, 10000);
        this.hashEstimatesShouldApproximateSimulations(3000, 10000);
        this.hashEstimatesShouldApproximateSimulations(5000, 10000);
        this.hashEstimatesShouldApproximateSimulations(7500, 10000);
        this.hashEstimatesShouldApproximateSimulations(9000, 10000);
    }

    private void hashEstimatesShouldApproximateSimulations(int numberOfValues, int hashTableSize) {
        for (int exponent = 1; exponent <= 4; ++exponent) {
            int scale = (int)Math.pow(10.0, exponent);
            double scaledEstimate = HashCollisionsEstimator.estimateNumberOfHashCollisions((int)(numberOfValues * scale), (int)(hashTableSize * scale));
            double simulatedEstimate = HashCollisionsSimulator.simulate(numberOfValues * scale, hashTableSize * scale, 2);
            Assert.assertEquals((double)scaledEstimate, (double)simulatedEstimate, (double)(simulatedEstimate * 0.05));
        }
    }
}

