/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import io.trino.Session;
import io.trino.cost.PlanCostEstimate;
import io.trino.sql.analyzer.FeaturesConfig;
import java.util.Objects;
import javax.inject.Inject;

public class CostComparator {
    private final double cpuWeight;
    private final double memoryWeight;
    private final double networkWeight;

    @Inject
    public CostComparator(FeaturesConfig featuresConfig) {
        this(featuresConfig.getCpuCostWeight(), featuresConfig.getMemoryCostWeight(), featuresConfig.getNetworkCostWeight());
    }

    @VisibleForTesting
    public CostComparator(double cpuWeight, double memoryWeight, double networkWeight) {
        Preconditions.checkArgument((cpuWeight >= 0.0 ? 1 : 0) != 0, (Object)"cpuWeight cannot be negative");
        Preconditions.checkArgument((memoryWeight >= 0.0 ? 1 : 0) != 0, (Object)"memoryWeight cannot be negative");
        Preconditions.checkArgument((networkWeight >= 0.0 ? 1 : 0) != 0, (Object)"networkWeight cannot be negative");
        this.cpuWeight = cpuWeight;
        this.memoryWeight = memoryWeight;
        this.networkWeight = networkWeight;
    }

    public Ordering<PlanCostEstimate> forSession(Session session) {
        Objects.requireNonNull(session, "session is null");
        return Ordering.from((left, right) -> this.compare(session, (PlanCostEstimate)left, (PlanCostEstimate)right));
    }

    public int compare(Session session, PlanCostEstimate left, PlanCostEstimate right) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        Preconditions.checkArgument((!left.hasUnknownComponents() && !right.hasUnknownComponents() ? 1 : 0) != 0, (Object)"cannot compare unknown costs");
        double leftCost = left.getCpuCost() * this.cpuWeight + left.getMaxMemory() * this.memoryWeight + left.getNetworkCost() * this.networkWeight;
        double rightCost = right.getCpuCost() * this.cpuWeight + right.getMaxMemory() * this.memoryWeight + right.getNetworkCost() * this.networkWeight;
        return Double.compare(leftCost, rightCost);
    }
}

