/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.sql.InterpretedFunctionInvoker;
import java.util.Collections;
import java.util.OptionalDouble;

final class StatsUtil {
    private StatsUtil() {
    }

    static OptionalDouble toStatsRepresentation(Metadata metadata, Session session, Type type, Object value) {
        if (StatsUtil.convertibleToDoubleWithCast(type)) {
            InterpretedFunctionInvoker functionInvoker = new InterpretedFunctionInvoker(metadata);
            ResolvedFunction castFunction = metadata.getCoercion(type, (Type)DoubleType.DOUBLE);
            return OptionalDouble.of((Double)functionInvoker.invoke(castFunction, session.toConnectorSession(), Collections.singletonList(value)));
        }
        if (DateType.DATE.equals((Object)type)) {
            return OptionalDouble.of(((Long)value).longValue());
        }
        if (type instanceof TimestampType) {
            if (((TimestampType)type).isShort()) {
                return OptionalDouble.of(((Long)value).longValue());
            }
            return OptionalDouble.of(((LongTimestamp)value).getEpochMicros());
        }
        return OptionalDouble.empty();
    }

    private static boolean convertibleToDoubleWithCast(Type type) {
        return type instanceof DecimalType || type instanceof DoubleType || type instanceof RealType || type instanceof BigintType || type instanceof IntegerType || type instanceof SmallintType || type instanceof TinyintType || type instanceof BooleanType;
    }
}

