/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.QualifiedName;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CommentTask
implements DataDefinitionTask<Comment> {
    @Override
    public String getName() {
        return "COMMENT";
    }

    @Override
    public ListenableFuture<Void> execute(Comment statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        if (statement.getType() == Comment.Type.TABLE) {
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
            Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
            if (tableHandle.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table does not exist: %s", tableName);
            }
            accessControl.checkCanSetTableComment(session.toSecurityContext(), tableName);
            metadata.setTableComment(session, tableHandle.get(), statement.getComment());
        } else if (statement.getType() == Comment.Type.COLUMN) {
            Optional prefix = statement.getName().getPrefix();
            if (prefix.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_TABLE, (Node)statement, "Table must be specified", new Object[0]);
            }
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, (QualifiedName)prefix.get());
            Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
            if (tableHandle.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table does not exist: " + tableName, new Object[0]);
            }
            String columnName = statement.getName().getSuffix();
            Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle.get());
            if (!columnHandles.containsKey(columnName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column does not exist: " + columnName, new Object[0]);
            }
            accessControl.checkCanSetColumnComment(session.toSecurityContext(), tableName);
            metadata.setColumnComment(session, tableHandle.get(), columnHandles.get(columnName), statement.getComment());
        } else {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Unsupported comment type: %s", statement.getType());
        }
        return Futures.immediateVoidFuture();
    }
}

