/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class DropSchemaTask
implements DataDefinitionTask<DropSchema> {
    @Override
    public String getName() {
        return "DROP SCHEMA";
    }

    @Override
    public String explain(DropSchema statement, List<Expression> parameters) {
        return "DROP SCHEMA " + statement.getSchemaName();
    }

    @Override
    public ListenableFuture<Void> execute(DropSchema statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        CatalogSchemaName schema;
        if (statement.isCascade()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CASCADE is not yet supported for DROP SCHEMA");
        }
        Session session = stateMachine.getSession();
        if (!metadata.schemaExists(session, schema = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSchemaName())))) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)statement, "Schema '%s' does not exist", schema);
            }
            return Futures.immediateVoidFuture();
        }
        if (!DropSchemaTask.isSchemaEmpty(session, schema, metadata)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, (Node)statement, "Cannot drop non-empty schema '%s'", schema.getSchemaName());
        }
        accessControl.checkCanDropSchema(session.toSecurityContext(), schema);
        metadata.dropSchema(session, schema);
        return Futures.immediateVoidFuture();
    }

    private static boolean isSchemaEmpty(Session session, CatalogSchemaName schema, Metadata metadata) {
        QualifiedTablePrefix tablePrefix = new QualifiedTablePrefix(schema.getCatalogName(), schema.getSchemaName());
        if (!metadata.listTables(session, tablePrefix).isEmpty()) {
            return false;
        }
        if (!metadata.listViews(session, tablePrefix).isEmpty()) {
            return false;
        }
        return metadata.listMaterializedViews(session, tablePrefix).isEmpty();
    }
}

