/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.security.SelectedRole;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetRole;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;

public class SetRoleTask
implements DataDefinitionTask<SetRole> {
    @Override
    public String getName() {
        return "SET ROLE";
    }

    @Override
    public ListenableFuture<Void> execute(SetRole statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        String catalog = MetadataUtil.getSessionCatalog(metadata, session, (Node)statement);
        if (statement.getType() == SetRole.Type.ROLE) {
            accessControl.checkCanSetRole(SecurityContext.of(session), statement.getRole().map(c -> c.getValue().toLowerCase(Locale.ENGLISH)).get(), catalog);
        }
        SelectedRole.Type type = SetRoleTask.toSelectedRoleType(statement.getType());
        stateMachine.addSetRole(catalog, new SelectedRole(type, statement.getRole().map(c -> c.getValue().toLowerCase(Locale.ENGLISH))));
        return Futures.immediateVoidFuture();
    }

    private static SelectedRole.Type toSelectedRoleType(SetRole.Type statementRoleType) {
        switch (statementRoleType) {
            case ROLE: {
                return SelectedRole.Type.ROLE;
            }
            case ALL: {
                return SelectedRole.Type.ALL;
            }
            case NONE: {
                return SelectedRole.Type.NONE;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + statementRoleType);
    }
}

