/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.ParameterRewriter;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class AbstractPropertyManager {
    private final ConcurrentMap<CatalogName, Map<String, PropertyMetadata<?>>> connectorProperties = new ConcurrentHashMap();
    private final String propertyType;
    private final ErrorCodeSupplier propertyError;

    protected AbstractPropertyManager(String propertyType, ErrorCodeSupplier propertyError) {
        Objects.requireNonNull(propertyType, "propertyType is null");
        this.propertyType = propertyType;
        this.propertyError = Objects.requireNonNull(propertyError, "propertyError is null");
    }

    public final void addProperties(CatalogName catalogName, List<PropertyMetadata<?>> properties) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(properties, "properties is null");
        ImmutableMap propertiesByName = Maps.uniqueIndex(properties, PropertyMetadata::getName);
        Preconditions.checkState((this.connectorProperties.putIfAbsent(catalogName, (Map<String, PropertyMetadata<?>>)propertiesByName) == null ? 1 : 0) != 0, (String)"Properties for connector '%s' are already registered", (Object)catalogName);
    }

    public final void removeProperties(CatalogName catalogName) {
        this.connectorProperties.remove(catalogName);
    }

    public final Map<String, Object> getProperties(CatalogName catalogName, String catalog, Map<String, Expression> sqlPropertyValues, Session session, Metadata metadata, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        Map supportedProperties = (Map)this.connectorProperties.get(catalogName);
        if (supportedProperties == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog not found: " + catalog);
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        for (Map.Entry<String, Expression> sqlProperty : sqlPropertyValues.entrySet()) {
            Object value;
            Object sqlObjectValue;
            String propertyName = sqlProperty.getKey().toLowerCase(Locale.ENGLISH);
            PropertyMetadata property = (PropertyMetadata)supportedProperties.get(propertyName);
            if (property == null) {
                throw new TrinoException(this.propertyError, String.format("Catalog '%s' does not support %s property '%s'", catalog, this.propertyType, propertyName));
            }
            try {
                sqlObjectValue = this.evaluatePropertyValue(sqlProperty.getValue(), property.getSqlType(), session, metadata, accessControl, parameters);
            }
            catch (TrinoException e) {
                throw new TrinoException(this.propertyError, String.format("Invalid value for %s property '%s': Cannot convert [%s] to %s", this.propertyType, property.getName(), sqlProperty.getValue(), property.getSqlType()), (Throwable)e);
            }
            try {
                value = property.decode(sqlObjectValue);
            }
            catch (Exception e) {
                throw new TrinoException(this.propertyError, String.format("Unable to set %s property '%s' to [%s]: %s", this.propertyType, property.getName(), sqlProperty.getValue(), e.getMessage()), (Throwable)e);
            }
            properties.put((Object)property.getName(), value);
        }
        ImmutableMap userSpecifiedProperties = properties.build();
        for (PropertyMetadata propertyMetadata : supportedProperties.values()) {
            Object value;
            if (userSpecifiedProperties.containsKey(propertyMetadata.getName()) || (value = propertyMetadata.getDefaultValue()) == null) continue;
            properties.put((Object)propertyMetadata.getName(), value);
        }
        return properties.build();
    }

    public Map<CatalogName, Map<String, PropertyMetadata<?>>> getAllProperties() {
        return ImmutableMap.copyOf(this.connectorProperties);
    }

    private Object evaluatePropertyValue(Expression expression, Type expectedType, Session session, Metadata metadata, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameters), (Expression)expression);
        Object value = ExpressionInterpreter.evaluateConstantExpression(rewritten, expectedType, metadata, session, accessControl, parameters);
        BlockBuilder blockBuilder = expectedType.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)expectedType, (BlockBuilder)blockBuilder, (Object)value);
        Object objectValue = expectedType.getObjectValue(session.toConnectorSession(), (Block)blockBuilder, 0);
        if (objectValue == null) {
            throw new TrinoException(this.propertyError, String.format("Invalid null value for %s property", this.propertyType));
        }
        return objectValue;
    }
}

