/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.SqlFunction;
import io.trino.operator.scalar.annotations.ScalarFromAnnotationsParser;
import io.trino.operator.window.WindowAnnotationsParser;
import io.trino.spi.function.WindowFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FunctionListBuilder {
    private final List<SqlFunction> functions = new ArrayList<SqlFunction>();

    public FunctionListBuilder window(Class<? extends WindowFunction> clazz) {
        this.functions.addAll(WindowAnnotationsParser.parseFunctionDefinition(clazz));
        return this;
    }

    public FunctionListBuilder aggregate(Class<?> aggregationDefinition) {
        this.functions.addAll(SqlAggregationFunction.createFunctionByAnnotations(aggregationDefinition));
        return this;
    }

    public FunctionListBuilder aggregates(Class<?> aggregationDefinition) {
        this.functions.addAll(SqlAggregationFunction.createFunctionsByAnnotations(aggregationDefinition));
        return this;
    }

    public FunctionListBuilder scalar(Class<?> clazz) {
        this.functions.addAll(ScalarFromAnnotationsParser.parseFunctionDefinition(clazz));
        return this;
    }

    public FunctionListBuilder scalars(Class<?> clazz) {
        this.functions.addAll(ScalarFromAnnotationsParser.parseFunctionDefinitions(clazz));
        return this;
    }

    public FunctionListBuilder functions(SqlFunction ... sqlFunctions) {
        for (SqlFunction sqlFunction : sqlFunctions) {
            this.function(sqlFunction);
        }
        return this;
    }

    public FunctionListBuilder function(SqlFunction sqlFunction) {
        Objects.requireNonNull(sqlFunction, "sqlFunction is null");
        this.functions.add(sqlFunction);
        return this;
    }

    public List<SqlFunction> getFunctions() {
        return ImmutableList.copyOf(this.functions);
    }
}

