/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.trino.connector.CatalogName;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;

public class TableMetadata {
    private final CatalogName catalogName;
    private final ConnectorTableMetadata metadata;

    public TableMetadata(CatalogName catalogName, ConnectorTableMetadata metadata) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.catalogName = catalogName;
        this.metadata = metadata;
    }

    public QualifiedObjectName getQualifiedName() {
        return new QualifiedObjectName(this.catalogName.getCatalogName(), this.metadata.getTable().getSchemaName(), this.metadata.getTable().getTableName());
    }

    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    public ConnectorTableMetadata getMetadata() {
        return this.metadata;
    }

    public SchemaTableName getTable() {
        return this.metadata.getTable();
    }

    public List<ColumnMetadata> getColumns() {
        return this.metadata.getColumns();
    }

    public ColumnMetadata getColumn(String name) {
        return this.getColumns().stream().filter(columnMetadata -> columnMetadata.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid column name: " + name));
    }
}

