/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.connector.CatalogName;
import io.trino.execution.buffer.PagesSerde;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.SerializedPage;
import io.trino.metadata.Split;
import io.trino.operator.DriverContext;
import io.trino.operator.ExchangeClient;
import io.trino.operator.ExchangeClientSupplier;
import io.trino.operator.OperatorContext;
import io.trino.operator.SourceOperator;
import io.trino.operator.SourceOperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.connector.UpdatablePageSource;
import io.trino.split.RemoteSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class ExchangeOperator
implements SourceOperator {
    public static final CatalogName REMOTE_CONNECTOR_ID = new CatalogName("$remote");
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final ExchangeClient exchangeClient;
    private final PagesSerde serde;
    private ListenableFuture<Void> isBlocked = NOT_BLOCKED;

    public ExchangeOperator(OperatorContext operatorContext, PlanNodeId sourceId, PagesSerde serde, ExchangeClient exchangeClient) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.exchangeClient = Objects.requireNonNull(exchangeClient, "exchangeClient is null");
        this.serde = Objects.requireNonNull(serde, "serde is null");
        operatorContext.setInfoSupplier(exchangeClient::getStatus);
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkArgument((boolean)split.getCatalogName().equals(REMOTE_CONNECTOR_ID), (Object)"split is not a remote split");
        URI location = ((RemoteSplit)split.getConnectorSplit()).getLocation();
        this.exchangeClient.addLocation(location);
        return Optional::empty;
    }

    @Override
    public void noMoreSplits() {
        this.exchangeClient.noMoreLocations();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.close();
    }

    @Override
    public boolean isFinished() {
        return this.exchangeClient.isFinished();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.exchangeClient.isBlocked();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot take input");
    }

    @Override
    public Page getOutput() {
        SerializedPage page = this.exchangeClient.pollPage();
        if (page == null) {
            return null;
        }
        this.operatorContext.recordNetworkInput(page.getSizeInBytes(), page.getPositionCount());
        Page deserializedPage = this.serde.deserialize(page);
        this.operatorContext.recordProcessedInput(deserializedPage.getSizeInBytes(), page.getPositionCount());
        return deserializedPage;
    }

    @Override
    public void close() {
        this.exchangeClient.close();
    }

    public static class ExchangeOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final ExchangeClientSupplier exchangeClientSupplier;
        private final PagesSerdeFactory serdeFactory;
        private ExchangeClient exchangeClient;
        private boolean closed;

        public ExchangeOperatorFactory(int operatorId, PlanNodeId sourceId, ExchangeClientSupplier exchangeClientSupplier, PagesSerdeFactory serdeFactory) {
            this.operatorId = operatorId;
            this.sourceId = sourceId;
            this.exchangeClientSupplier = exchangeClientSupplier;
            this.serdeFactory = serdeFactory;
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, ExchangeOperator.class.getSimpleName());
            if (this.exchangeClient == null) {
                this.exchangeClient = this.exchangeClientSupplier.get(driverContext.getPipelineContext().localSystemMemoryContext());
            }
            return new ExchangeOperator(operatorContext, this.sourceId, this.serdeFactory.createPagesSerde(), this.exchangeClient);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

