/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.trino.metadata.FunctionArgumentDefinition;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.AggregationUtils;
import io.trino.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.operator.aggregation.state.LongState;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class CountColumn
extends SqlAggregationFunction {
    public static final CountColumn COUNT_COLUMN = new CountColumn();
    private static final String NAME = "count";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(CountColumn.class, "input", LongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle REMOVE_INPUT_FUNCTION = Reflection.methodHandle(CountColumn.class, "removeInput", LongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(CountColumn.class, "combine", LongState.class, LongState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(CountColumn.class, "output", LongState.class, BlockBuilder.class);

    public CountColumn() {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), false, true, "Counts the non-null values", FunctionKind.AGGREGATE), true, false);
    }

    @Override
    public List<TypeSignature> getIntermediateTypes(FunctionBinding functionBinding) {
        return ImmutableList.of((Object)StateCompiler.getSerializedType(LongState.class).getTypeSignature());
    }

    @Override
    public InternalAggregationFunction specialize(FunctionBinding functionBinding) {
        Type type = functionBinding.getTypeVariable("T");
        return CountColumn.generateAggregation(type);
    }

    private static InternalAggregationFunction generateAggregation(Type type) {
        DynamicClassLoader classLoader = new DynamicClassLoader(CountColumn.class.getClassLoader());
        AccumulatorStateSerializer<LongState> stateSerializer = StateCompiler.generateStateSerializer(LongState.class, classLoader);
        AccumulatorStateFactory<LongState> stateFactory = StateCompiler.generateStateFactory(LongState.class, classLoader);
        Type intermediateType = stateSerializer.getSerializedType();
        ImmutableList inputTypes = ImmutableList.of((Object)type);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, BigintType.BIGINT.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), CountColumn.createInputParameterMetadata(type), INPUT_FUNCTION, Optional.of(REMOVE_INPUT_FUNCTION), COMBINE_FUNCTION, OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(LongState.class, stateSerializer, stateFactory)), (Type)BigintType.BIGINT);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), (Type)BigintType.BIGINT, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(LongState state, Block block, int index) {
        state.setLong(state.getLong() + 1L);
    }

    public static void removeInput(LongState state, Block block, int index) {
        state.setLong(state.getLong() - 1L);
    }

    public static void combine(LongState state, LongState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
    }

    public static void output(LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getLong());
    }
}

