/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.AggregationUtils;
import io.trino.operator.aggregation.state.CovarianceState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DoubleType;

@AggregationFunction
public final class DoubleCovarianceAggregation {
    private DoubleCovarianceAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState CovarianceState state, @SqlType(value="double") double dependentValue, @SqlType(value="double") double independentValue) {
        AggregationUtils.updateCovarianceState(state, independentValue, dependentValue);
    }

    @CombineFunction
    public static void combine(@AggregationState CovarianceState state, @AggregationState CovarianceState otherState) {
        AggregationUtils.mergeCovarianceState(state, otherState);
    }

    @AggregationFunction(value="covar_samp")
    @OutputFunction(value="double")
    public static void covarSamp(@AggregationState CovarianceState state, BlockBuilder out) {
        if (state.getCount() <= 1L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovarianceSample(state);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="covar_pop")
    @OutputFunction(value="double")
    public static void covarPop(@AggregationState CovarianceState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovariancePopulation(state);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }
}

