/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;

public class LongDecimalWithOverflowAndLongStateSerializer
implements AccumulatorStateSerializer<LongDecimalWithOverflowAndLongState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        if (state.getLongDecimal() == null) {
            out.appendNull();
        } else {
            Slice slice = Slices.allocate((int)32);
            SliceOutput output = slice.getOutput();
            output.writeLong(state.getLong());
            output.writeLong(state.getOverflow());
            output.writeBytes(state.getLongDecimal());
            VarbinaryType.VARBINARY.writeSlice(out, slice);
        }
    }

    public void deserialize(Block block, int index, LongDecimalWithOverflowAndLongState state) {
        if (!block.isNull(index)) {
            BasicSliceInput slice = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
            state.setLong(slice.readLong());
            state.setOverflow(slice.readLong());
            state.setLongDecimal(Slices.copyOf((Slice)slice.readSlice(slice.available())));
        }
    }
}

