/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.PartitionFunction;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.operator.exchange.PageReference;
import io.trino.spi.Page;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

class PartitioningExchanger
implements LocalExchanger {
    private final List<Consumer<PageReference>> buffers;
    private final LocalExchangeMemoryManager memoryManager;
    private final Function<Page, Page> partitionedPagePreparer;
    private final PartitionFunction partitionFunction;
    private final IntArrayList[] partitionAssignments;
    private final PageReference.PageReleasedListener onPageReleased;

    public PartitioningExchanger(List<Consumer<PageReference>> partitions, LocalExchangeMemoryManager memoryManager, Function<Page, Page> partitionPagePreparer, PartitionFunction partitionFunction) {
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitions, "partitions is null"));
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.onPageReleased = PageReference.PageReleasedListener.forLocalExchangeMemoryManager(memoryManager);
        this.partitionedPagePreparer = Objects.requireNonNull(partitionPagePreparer, "partitionPagePreparer is null");
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        this.partitionAssignments = new IntArrayList[partitions.size()];
        for (int i = 0; i < this.partitionAssignments.length; ++i) {
            this.partitionAssignments[i] = new IntArrayList();
        }
    }

    @Override
    public synchronized void accept(Page page) {
        for (IntArrayList partitionAssignment : this.partitionAssignments) {
            partitionAssignment.clear();
        }
        Page partitionPage = this.partitionedPagePreparer.apply(page);
        for (int position = 0; position < partitionPage.getPositionCount(); ++position) {
            int partition = this.partitionFunction.getPartition(partitionPage, position);
            this.partitionAssignments[partition].add(position);
        }
        for (int partition = 0; partition < this.buffers.size(); ++partition) {
            IntArrayList positions = this.partitionAssignments[partition];
            if (positions.isEmpty()) continue;
            Page pageSplit = page.copyPositions(positions.elements(), 0, positions.size());
            this.memoryManager.updateMemoryUsage(pageSplit.getRetainedSizeInBytes());
            this.buffers.get(partition).accept(new PageReference(pageSplit, 1, this.onPageReleased));
        }
    }

    @Override
    public ListenableFuture<Void> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

