/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.util.MorePredicates;
import java.util.List;

public final class JoinUtils {
    private JoinUtils() {
    }

    public static List<Page> channelsToPages(List<List<Block>> channels) {
        if (channels.isEmpty()) {
            return ImmutableList.of();
        }
        int pagesCount = channels.get(0).size();
        ImmutableList.Builder pagesBuilder = ImmutableList.builderWithExpectedSize((int)pagesCount);
        for (int pageIndex = 0; pageIndex < pagesCount; ++pageIndex) {
            Block[] blocks = new Block[channels.size()];
            for (int channelIndex = 0; channelIndex < blocks.length; ++channelIndex) {
                blocks[channelIndex] = channels.get(channelIndex).get(pageIndex);
            }
            pagesBuilder.add((Object)new Page(blocks));
        }
        return pagesBuilder.build();
    }

    public static boolean isBuildSideReplicated(PlanNode node) {
        Preconditions.checkArgument((boolean)MorePredicates.isInstanceOfAny(JoinNode.class, SemiJoinNode.class).test(node));
        if (node instanceof JoinNode) {
            return PlanNodeSearcher.searchFrom(((JoinNode)node).getRight()).recurseOnlyWhen(MorePredicates.isInstanceOfAny(ProjectNode.class).or(JoinUtils::isLocalRepartitionExchange).or(JoinUtils::isLocalGatherExchange)).where(joinNode -> JoinUtils.isRemoteReplicatedExchange(joinNode) || JoinUtils.isRemoteReplicatedSourceNode(joinNode)).matches();
        }
        return PlanNodeSearcher.searchFrom(((SemiJoinNode)node).getFilteringSource()).recurseOnlyWhen(MorePredicates.isInstanceOfAny(ProjectNode.class).or(JoinUtils::isLocalGatherExchange)).where(joinNode -> JoinUtils.isRemoteReplicatedExchange(joinNode) || JoinUtils.isRemoteReplicatedSourceNode(joinNode)).matches();
    }

    private static boolean isRemoteReplicatedExchange(PlanNode node) {
        if (!(node instanceof ExchangeNode)) {
            return false;
        }
        ExchangeNode exchangeNode = (ExchangeNode)node;
        return exchangeNode.getScope() == ExchangeNode.Scope.REMOTE && exchangeNode.getType() == ExchangeNode.Type.REPLICATE;
    }

    private static boolean isRemoteReplicatedSourceNode(PlanNode node) {
        if (!(node instanceof RemoteSourceNode)) {
            return false;
        }
        RemoteSourceNode remoteSourceNode = (RemoteSourceNode)node;
        return remoteSourceNode.getExchangeType() == ExchangeNode.Type.REPLICATE;
    }

    private static boolean isLocalRepartitionExchange(PlanNode node) {
        if (!(node instanceof ExchangeNode)) {
            return false;
        }
        ExchangeNode exchangeNode = (ExchangeNode)node;
        return exchangeNode.getScope() == ExchangeNode.Scope.LOCAL && exchangeNode.getType() == ExchangeNode.Type.REPARTITION;
    }

    private static boolean isLocalGatherExchange(PlanNode node) {
        if (!(node instanceof ExchangeNode)) {
            return false;
        }
        ExchangeNode exchangeNode = (ExchangeNode)node;
        return exchangeNode.getScope() == ExchangeNode.Scope.LOCAL && exchangeNode.getType() == ExchangeNode.Type.GATHER;
    }
}

