/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.pattern;

import io.airlift.slice.Slices;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.Work;
import io.trino.operator.project.PageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.pattern.PhysicalValuePointer;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class MeasureComputation {
    private final PageProjection projection;
    private final List<PhysicalValuePointer> expectedLayout;
    private final Type type;
    private final List<String> labelNames;
    private final ConnectorSession session;

    public MeasureComputation(PageProjection projection, List<PhysicalValuePointer> expectedLayout, Type type, List<String> labelNames, ConnectorSession session) {
        this.projection = Objects.requireNonNull(projection, "projection is null");
        this.expectedLayout = Objects.requireNonNull(expectedLayout, "expectedLayout is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.labelNames = Objects.requireNonNull(labelNames, "labelNames is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public Type getType() {
        return this.type;
    }

    public Block compute(int currentRow, ArrayView matchedLabels, int partitionStart, int searchStart, int searchEnd, int patternStart, long matchNumber, WindowIndex windowIndex) {
        Block[] blocks = new Block[this.expectedLayout.size()];
        for (int i = 0; i < this.expectedLayout.size(); ++i) {
            PhysicalValuePointer pointer = this.expectedLayout.get(i);
            int channel = pointer.getSourceChannel();
            if (channel == -2) {
                blocks[i] = Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)matchNumber);
                continue;
            }
            int position = pointer.getLogicalIndexNavigation().resolvePosition(currentRow, matchedLabels, searchStart, searchEnd, patternStart);
            if (position >= 0) {
                if (channel == -1) {
                    VarcharType type = VarcharType.VARCHAR;
                    if (position < patternStart || position >= patternStart + matchedLabels.length()) {
                        blocks[i] = Utils.nativeValueToBlock((Type)type, null);
                        continue;
                    }
                    blocks[i] = Utils.nativeValueToBlock((Type)type, (Object)Slices.utf8Slice((String)this.labelNames.get(matchedLabels.get(position - patternStart))));
                    continue;
                }
                blocks[i] = windowIndex.getSingleValueBlock(channel, position - partitionStart);
                continue;
            }
            blocks[i] = Utils.nativeValueToBlock((Type)pointer.getType(), null);
        }
        Page page = new Page(1, blocks);
        Work<Block> work = this.projection.project(this.session, new DriverYieldSignal(), this.projection.getInputChannels().getInputChannels(page), SelectedPositions.positionsRange(0, 1));
        boolean done = false;
        while (!done) {
            done = work.process();
        }
        return work.getResult();
    }

    public Block computeEmpty(long matchNumber) {
        Block[] blocks = new Block[this.expectedLayout.size()];
        for (int i = 0; i < this.expectedLayout.size(); ++i) {
            PhysicalValuePointer physicalValuePointer = this.expectedLayout.get(i);
            blocks[i] = physicalValuePointer.getSourceChannel() == -2 ? Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)matchNumber) : Utils.nativeValueToBlock((Type)physicalValuePointer.getType(), null);
        }
        Page page = new Page(1, blocks);
        Work<Block> work = this.projection.project(this.session, new DriverYieldSignal(), this.projection.getInputChannels().getInputChannels(page), SelectedPositions.positionsRange(0, 1));
        boolean done = false;
        while (!done) {
            done = work.process();
        }
        return work.getResult();
    }

    public static class MeasureComputationSupplier {
        private final Supplier<PageProjection> projection;
        private final List<PhysicalValuePointer> expectedLayout;
        private final Type type;
        private final List<String> labelNames;
        private final ConnectorSession session;

        public MeasureComputationSupplier(Supplier<PageProjection> projection, List<PhysicalValuePointer> expectedLayout, Type type, List<String> labelNames, ConnectorSession session) {
            this.projection = Objects.requireNonNull(projection, "projection is null");
            this.expectedLayout = Objects.requireNonNull(expectedLayout, "expectedLayout is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.labelNames = Objects.requireNonNull(labelNames, "labelNames is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public MeasureComputation get() {
            return new MeasureComputation(this.projection.get(), this.expectedLayout, this.type, this.labelNames, this.session);
        }
    }
}

