/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.server.SessionContext;
import io.trino.server.SessionSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.security.Identity;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.SqlEnvironmentConfig;
import io.trino.sql.SqlPath;
import io.trino.transaction.TransactionManager;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class QuerySessionSupplier
implements SessionSupplier {
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final SessionPropertyManager sessionPropertyManager;
    private final Optional<String> path;
    private final Optional<TimeZoneKey> forcedSessionTimeZone;
    private final Optional<String> defaultCatalog;
    private final Optional<String> defaultSchema;

    @Inject
    public QuerySessionSupplier(TransactionManager transactionManager, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, SqlEnvironmentConfig config) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        Objects.requireNonNull(config, "config is null");
        this.path = Objects.requireNonNull(config.getPath(), "path is null");
        this.forcedSessionTimeZone = Objects.requireNonNull(config.getForcedSessionTimeZone(), "forcedSessionTimeZone is null");
        this.defaultCatalog = Objects.requireNonNull(config.getDefaultCatalog(), "defaultCatalog is null");
        this.defaultSchema = Objects.requireNonNull(config.getDefaultSchema(), "defaultSchema is null");
        Preconditions.checkArgument((this.defaultCatalog.isPresent() || this.defaultSchema.isEmpty() ? 1 : 0) != 0, (Object)"Default schema cannot be set if catalog is not set");
    }

    @Override
    public Session createSession(QueryId queryId, SessionContext context) {
        Identity identity = context.getIdentity();
        this.accessControl.checkCanSetUser(identity.getPrincipal(), identity.getUser());
        context.getAuthenticatedIdentity().ifPresent(authenticatedIdentity -> {
            if (!authenticatedIdentity.getUser().equals(identity.getUser())) {
                this.accessControl.checkCanImpersonateUser((Identity)authenticatedIdentity, identity.getUser());
            }
        });
        Session.SessionBuilder sessionBuilder = Session.builder(this.sessionPropertyManager).setQueryId(queryId).setIdentity(identity).setSource(context.getSource()).setPath(new SqlPath(this.path)).setRemoteUserAddress(context.getRemoteUserAddress()).setUserAgent(context.getUserAgent()).setClientInfo(context.getClientInfo()).setClientTags(context.getClientTags()).setClientCapabilities(context.getClientCapabilities()).setTraceToken(context.getTraceToken()).setResourceEstimates(context.getResourceEstimates()).setProtocolHeaders(context.getProtocolHeaders());
        this.defaultCatalog.ifPresent(sessionBuilder::setCatalog);
        this.defaultSchema.ifPresent(sessionBuilder::setSchema);
        if (context.getCatalog() != null) {
            sessionBuilder.setCatalog(context.getCatalog());
        }
        if (context.getSchema() != null) {
            sessionBuilder.setSchema(context.getSchema());
        }
        if (context.getPath() != null) {
            sessionBuilder.setPath(new SqlPath(Optional.of(context.getPath())));
        }
        if (this.forcedSessionTimeZone.isPresent()) {
            sessionBuilder.setTimeZoneKey(this.forcedSessionTimeZone.get());
        } else {
            String sessionTimeZoneId = context.getSystemProperties().get("time_zone_id");
            if (sessionTimeZoneId != null) {
                sessionBuilder.setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionTimeZoneId));
            } else if (context.getTimeZoneId() != null) {
                sessionBuilder.setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)context.getTimeZoneId()));
            }
        }
        if (context.getLanguage() != null) {
            sessionBuilder.setLocale(Locale.forLanguageTag(context.getLanguage()));
        }
        for (Map.Entry entry : context.getSystemProperties().entrySet()) {
            sessionBuilder.setSystemProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<String, Map<String, String>> entry : context.getCatalogSessionProperties().entrySet()) {
            String catalog = entry.getKey();
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                sessionBuilder.setCatalogSessionProperty(catalog, entry2.getKey(), entry2.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : context.getPreparedStatements().entrySet()) {
            sessionBuilder.addPreparedStatement(entry.getKey(), (String)entry.getValue());
        }
        if (context.supportClientTransaction()) {
            sessionBuilder.setClientTransactionSupport();
        }
        Session session = sessionBuilder.build();
        if (context.getTransactionId().isPresent()) {
            session = session.beginTransactionId(context.getTransactionId().get(), this.transactionManager, this.accessControl);
        }
        return session;
    }
}

