/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.trino.server.security.oauth2.OAuth2Config;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class OAuth2TokenExchange {
    public static final Duration MAX_POLL_TIME = new Duration(10.0, TimeUnit.SECONDS);
    private static final TokenPoll TOKEN_POLL_TIMED_OUT = TokenPoll.error("Authentication has timed out");
    private final LoadingCache<UUID, SettableFuture<TokenPoll>> cache;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"oauth2-token-exchange"));

    @Inject
    public OAuth2TokenExchange(OAuth2Config config) {
        final long challengeTimeoutMillis = config.getChallengeTimeout().toMillis();
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(challengeTimeoutMillis + MAX_POLL_TIME.toMillis() * 10L, TimeUnit.MILLISECONDS).removalListener(notification -> ((SettableFuture)notification.getValue()).set((Object)TOKEN_POLL_TIMED_OUT)).build((CacheLoader)new CacheLoader<UUID, SettableFuture<TokenPoll>>(){

            public SettableFuture<TokenPoll> load(UUID authId) {
                SettableFuture future = SettableFuture.create();
                ScheduledFuture<Boolean> timeout = OAuth2TokenExchange.this.executor.schedule(() -> future.set((Object)TOKEN_POLL_TIMED_OUT), challengeTimeoutMillis, TimeUnit.MILLISECONDS);
                future.addListener(() -> timeout.cancel(true), (Executor)OAuth2TokenExchange.this.executor);
                return future;
            }
        });
    }

    @PreDestroy
    public void stop() {
        this.executor.shutdownNow();
    }

    public void setAccessToken(UUID authId, String accessToken) {
        ((SettableFuture)this.cache.getUnchecked((Object)authId)).set((Object)TokenPoll.token(accessToken));
    }

    public void setTokenExchangeError(UUID authId, String message) {
        ((SettableFuture)this.cache.getUnchecked((Object)authId)).set((Object)TokenPoll.error(message));
    }

    public ListenableFuture<TokenPoll> getTokenPoll(UUID authId) {
        return Futures.nonCancellationPropagating((ListenableFuture)((ListenableFuture)this.cache.getUnchecked((Object)authId)));
    }

    public void dropToken(UUID authId) {
        this.cache.invalidate((Object)authId);
    }

    public static class TokenPoll {
        private final Optional<String> token;
        private final Optional<String> error;

        private TokenPoll(String token, String error) {
            this.token = Optional.ofNullable(token);
            this.error = Optional.ofNullable(error);
        }

        static TokenPoll token(String token) {
            Objects.requireNonNull(token, "token is null");
            return new TokenPoll(token, null);
        }

        static TokenPoll error(String error) {
            Objects.requireNonNull(error, "error is null");
            return new TokenPoll(null, error);
        }

        public Optional<String> getToken() {
            return this.token;
        }

        public Optional<String> getError() {
            return this.error;
        }
    }
}

