/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.Session;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.CharLiteral;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ConnectorExpressionTranslator {
    private ConnectorExpressionTranslator() {
    }

    public static Expression translate(ConnectorExpression expression, Map<String, Symbol> variableMappings, LiteralEncoder literalEncoder) {
        return new ConnectorToSqlExpressionTranslator(variableMappings, literalEncoder).translate(expression);
    }

    public static Optional<ConnectorExpression> translate(Session session, Expression expression, TypeAnalyzer types, TypeProvider inputTypes) {
        return (Optional)new SqlToConnectorExpressionTranslator(types.getTypes(session, inputTypes, expression)).process((Node)expression);
    }

    static class SqlToConnectorExpressionTranslator
    extends AstVisitor<Optional<ConnectorExpression>, Void> {
        private final Map<NodeRef<Expression>, Type> types;

        public SqlToConnectorExpressionTranslator(Map<NodeRef<Expression>, Type> types) {
            this.types = Objects.requireNonNull(types, "types is null");
        }

        protected Optional<ConnectorExpression> visitSymbolReference(SymbolReference node, Void context) {
            return Optional.of(new Variable(node.getName(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitBooleanLiteral(BooleanLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getValue(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitStringLiteral(StringLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getSlice(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitDoubleLiteral(DoubleLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getValue(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitDecimalLiteral(DecimalLiteral node, Void context) {
            return Optional.of(new Constant(Decimals.parse((String)node.getValue()).getObject(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitCharLiteral(CharLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getSlice(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitBinaryLiteral(BinaryLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getValue(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitLongLiteral(LongLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getValue(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitNullLiteral(NullLiteral node, Void context) {
            return Optional.of(new Constant(null, this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitSubscriptExpression(SubscriptExpression node, Void context) {
            if (!(this.typeOf(node.getBase()) instanceof RowType)) {
                return Optional.empty();
            }
            Optional translatedBase = (Optional)this.process((Node)node.getBase());
            if (translatedBase.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new FieldDereference(this.typeOf((Expression)node), (ConnectorExpression)translatedBase.get(), (int)(((LongLiteral)node.getIndex()).getValue() - 1L)));
        }

        protected Optional<ConnectorExpression> visitExpression(Expression node, Void context) {
            return Optional.empty();
        }

        private Type typeOf(Expression node) {
            return this.types.get(NodeRef.of((Node)node));
        }
    }

    private static class ConnectorToSqlExpressionTranslator {
        private final Map<String, Symbol> variableMappings;
        private final LiteralEncoder literalEncoder;

        public ConnectorToSqlExpressionTranslator(Map<String, Symbol> variableMappings, LiteralEncoder literalEncoder) {
            this.variableMappings = Objects.requireNonNull(variableMappings, "variableMappings is null");
            this.literalEncoder = Objects.requireNonNull(literalEncoder, "literalEncoder is null");
        }

        public Expression translate(ConnectorExpression expression) {
            if (expression instanceof Variable) {
                return this.variableMappings.get(((Variable)expression).getName()).toSymbolReference();
            }
            if (expression instanceof Constant) {
                return this.literalEncoder.toExpression(((Constant)expression).getValue(), expression.getType());
            }
            if (expression instanceof FieldDereference) {
                FieldDereference dereference = (FieldDereference)expression;
                return new SubscriptExpression(this.translate(dereference.getTarget()), (Expression)new LongLiteral(Long.toString(dereference.getField() + 1)));
            }
            throw new UnsupportedOperationException("Expression type not supported: " + expression.getClass().getName());
        }
    }
}

