/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.AllOrNoneValueSet;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.Ranges;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.InterpretedFunctionInvoker;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DomainCoercer {
    private DomainCoercer() {
    }

    public static Domain applySaturatedCasts(Metadata metadata, TypeOperators typeOperators, Session session, Domain domain, Type coercedValueType) {
        return new ImplicitCoercer(metadata, typeOperators, session, domain, coercedValueType).applySaturatedCasts();
    }

    private static class ImplicitCoercer {
        private final ConnectorSession connectorSession;
        private final InterpretedFunctionInvoker functionInvoker;
        private final ResolvedFunction saturatedFloorCastOperator;
        private final ResolvedFunction castToOriginalTypeOperator;
        private final MethodHandle comparisonOperator;
        private final Domain domain;
        private final Type coercedValueType;

        private ImplicitCoercer(Metadata metadata, TypeOperators typeOperators, Session session, Domain domain, Type coercedValueType) {
            this.connectorSession = Objects.requireNonNull(session, "session is null").toConnectorSession();
            this.functionInvoker = new InterpretedFunctionInvoker(metadata);
            this.domain = Objects.requireNonNull(domain, "domain is null");
            this.coercedValueType = Objects.requireNonNull(coercedValueType, "coercedValueType is null");
            Type originalValueType = domain.getType();
            try {
                this.saturatedFloorCastOperator = metadata.getCoercion(OperatorType.SATURATED_FLOOR_CAST, originalValueType, coercedValueType);
            }
            catch (OperatorNotFoundException e) {
                throw new IllegalStateException(String.format("Saturated floor cast operator not found for coercion from %s to %s", originalValueType, coercedValueType));
            }
            this.castToOriginalTypeOperator = metadata.getCoercion(coercedValueType, originalValueType);
            this.comparisonOperator = typeOperators.getComparisonOperator(originalValueType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
        }

        public Domain applySaturatedCasts() {
            if (this.domain.isNone()) {
                return Domain.none((Type)this.coercedValueType);
            }
            ValueSet saturatedValueSet = (ValueSet)this.domain.getValues().getValuesProcessor().transform(this::applySaturatedCasts, discreteValues -> ValueSet.all((Type)this.coercedValueType), allOrNone -> new AllOrNoneValueSet(this.coercedValueType, allOrNone.isAll()));
            return Domain.create((ValueSet)saturatedValueSet, (boolean)this.domain.isNullAllowed());
        }

        private ValueSet applySaturatedCasts(Ranges ranges) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Range range : ranges.getOrderedRanges()) {
                Optional<Range> coercedRange = this.applySaturatedCasts(range);
                if (coercedRange.isEmpty()) continue;
                if (coercedRange.get().isAll()) {
                    return ValueSet.all((Type)this.coercedValueType);
                }
                builder.add((Object)coercedRange.get());
            }
            return SortedRangeSet.copyOf((Type)this.coercedValueType, (List)builder.build());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Optional<Range> applySaturatedCasts(Range range) {
            Range coercedHigh;
            Range coercedLow;
            if (range.isSingleValue()) {
                Optional<Object> coercedValue = this.applySaturatedCast(range.getSingleValue());
                return coercedValue.map(value -> Range.equal((Type)this.coercedValueType, (Object)value));
            }
            if (range.isLowUnbounded()) {
                coercedLow = Range.all((Type)this.coercedValueType);
            } else {
                boolean coercedValueIsLessThanOriginal;
                Object coercedLowValue;
                Object originalLowValue = range.getLowBoundedValue();
                int originalComparedToCoerced = this.compareOriginalValueToCoerced(this.castToOriginalTypeOperator, this.comparisonOperator, originalLowValue, coercedLowValue = this.floorValue(this.saturatedFloorCastOperator, originalLowValue));
                boolean coercedValueIsEqualToOriginal = originalComparedToCoerced == 0;
                boolean bl = coercedValueIsLessThanOriginal = originalComparedToCoerced > 0;
                coercedLow = range.isLowInclusive() ? (coercedValueIsEqualToOriginal ? Range.greaterThanOrEqual((Type)this.coercedValueType, (Object)coercedLowValue) : (coercedValueIsLessThanOriginal ? Range.greaterThan((Type)this.coercedValueType, (Object)coercedLowValue) : Range.all((Type)this.coercedValueType))) : (coercedValueIsEqualToOriginal || coercedValueIsLessThanOriginal ? Range.greaterThan((Type)this.coercedValueType, (Object)coercedLowValue) : Range.all((Type)this.coercedValueType));
            }
            if (range.isHighUnbounded()) {
                coercedHigh = Range.all((Type)this.coercedValueType);
                return coercedLow.intersect(coercedHigh);
            } else {
                boolean coercedValueIsLessThanOriginal;
                Object coercedHighValue;
                Object originalHighValue = range.getHighBoundedValue();
                int originalComparedToCoerced = this.compareOriginalValueToCoerced(this.castToOriginalTypeOperator, this.comparisonOperator, originalHighValue, coercedHighValue = this.floorValue(this.saturatedFloorCastOperator, originalHighValue));
                boolean coercedValueIsEqualToOriginal = originalComparedToCoerced == 0;
                boolean bl = coercedValueIsLessThanOriginal = originalComparedToCoerced > 0;
                if (range.isHighInclusive()) {
                    if (!coercedValueIsEqualToOriginal && !coercedValueIsLessThanOriginal) return Optional.empty();
                    coercedHigh = Range.lessThanOrEqual((Type)this.coercedValueType, (Object)coercedHighValue);
                    return coercedLow.intersect(coercedHigh);
                } else if (coercedValueIsEqualToOriginal) {
                    coercedHigh = Range.lessThan((Type)this.coercedValueType, (Object)coercedHighValue);
                    return coercedLow.intersect(coercedHigh);
                } else {
                    if (!coercedValueIsLessThanOriginal) return Optional.empty();
                    coercedHigh = Range.lessThanOrEqual((Type)this.coercedValueType, (Object)coercedHighValue);
                }
            }
            return coercedLow.intersect(coercedHigh);
        }

        private Optional<Object> applySaturatedCast(Object originalValue) {
            Object coercedFloorValue = this.floorValue(this.saturatedFloorCastOperator, originalValue);
            int originalComparedToCoerced = this.compareOriginalValueToCoerced(this.castToOriginalTypeOperator, this.comparisonOperator, originalValue, coercedFloorValue);
            if (originalComparedToCoerced == 0) {
                return Optional.of(coercedFloorValue);
            }
            return Optional.empty();
        }

        private int compareOriginalValueToCoerced(ResolvedFunction castToOriginalTypeOperator, MethodHandle comparisonOperator, Object originalValue, Object coercedValue) {
            Object coercedValueInOriginalType = this.functionInvoker.invoke(castToOriginalTypeOperator, this.connectorSession, coercedValue);
            try {
                return (int)comparisonOperator.invoke(originalValue, coercedValueInOriginalType);
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
            }
        }

        private Object floorValue(ResolvedFunction saturatedFloorCastOperator, Object value) {
            return this.functionInvoker.invoke(saturatedFloorCastOperator, this.connectorSession, value);
        }
    }
}

