/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.statistics.TableStatisticType;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.StatisticAggregations;
import io.trino.sql.planner.plan.StatisticAggregationsDescriptor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StatisticsAggregationPlanner {
    private final SymbolAllocator symbolAllocator;
    private final Metadata metadata;

    public StatisticsAggregationPlanner(SymbolAllocator symbolAllocator, Metadata metadata) {
        this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public TableStatisticAggregation createStatisticsAggregation(TableStatisticsMetadata statisticsMetadata, Map<String, Symbol> columnToSymbolMap) {
        StatisticAggregationsDescriptor.Builder descriptor = StatisticAggregationsDescriptor.builder();
        List groupingColumns = statisticsMetadata.getGroupingColumns();
        List groupingSymbols = (List)groupingColumns.stream().map(columnToSymbolMap::get).collect(ImmutableList.toImmutableList());
        for (int i = 0; i < groupingSymbols.size(); ++i) {
            descriptor.addGrouping((String)groupingColumns.get(i), (Symbol)groupingSymbols.get(i));
        }
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (TableStatisticType type : statisticsMetadata.getTableStatistics()) {
            if (type != TableStatisticType.ROW_COUNT) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table-wide statistic type not supported: " + type);
            }
            AggregationNode.Aggregation aggregation = new AggregationNode.Aggregation(this.metadata.resolveFunction(QualifiedName.of((String)"count"), (List<TypeSignatureProvider>)ImmutableList.of()), (List<Expression>)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty());
            Symbol symbol = this.symbolAllocator.newSymbol("rowCount", (Type)BigintType.BIGINT);
            aggregations.put((Object)symbol, (Object)aggregation);
            descriptor.addTableStatistic(TableStatisticType.ROW_COUNT, symbol);
        }
        for (ColumnStatisticMetadata columnStatisticMetadata : statisticsMetadata.getColumnStatistics()) {
            String columnName = columnStatisticMetadata.getColumnName();
            ColumnStatisticType statisticType = columnStatisticMetadata.getStatisticType();
            Symbol inputSymbol = columnToSymbolMap.get(columnName);
            Verify.verifyNotNull((Object)inputSymbol, (String)"inputSymbol is null", (Object[])new Object[0]);
            Type inputType = this.symbolAllocator.getTypes().get(inputSymbol);
            Verify.verifyNotNull((Object)inputType, (String)"inputType is null for symbol: %s", (Object[])new Object[]{inputSymbol});
            ColumnStatisticsAggregation aggregation = this.createColumnAggregation(statisticType, inputSymbol, inputType);
            Symbol symbol = this.symbolAllocator.newSymbol(statisticType + ":" + columnName, aggregation.getOutputType());
            aggregations.put((Object)symbol, (Object)aggregation.getAggregation());
            descriptor.addColumnStatistic(columnStatisticMetadata, symbol);
        }
        StatisticAggregations aggregation = new StatisticAggregations((Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), groupingSymbols);
        return new TableStatisticAggregation(aggregation, descriptor.build());
    }

    private ColumnStatisticsAggregation createColumnAggregation(ColumnStatisticType statisticType, Symbol input, Type inputType) {
        switch (statisticType) {
            case MIN_VALUE: {
                return this.createAggregation(QualifiedName.of((String)"min"), input.toSymbolReference(), inputType, inputType);
            }
            case MAX_VALUE: {
                return this.createAggregation(QualifiedName.of((String)"max"), input.toSymbolReference(), inputType, inputType);
            }
            case NUMBER_OF_DISTINCT_VALUES: {
                return this.createAggregation(QualifiedName.of((String)"approx_distinct"), input.toSymbolReference(), inputType, (Type)BigintType.BIGINT);
            }
            case NUMBER_OF_DISTINCT_VALUES_SUMMARY: {
                return this.createAggregation(QualifiedName.of((String)"$approx_set"), input.toSymbolReference(), inputType, (Type)HyperLogLogType.HYPER_LOG_LOG);
            }
            case NUMBER_OF_NON_NULL_VALUES: {
                return this.createAggregation(QualifiedName.of((String)"count"), input.toSymbolReference(), inputType, (Type)BigintType.BIGINT);
            }
            case NUMBER_OF_TRUE_VALUES: {
                return this.createAggregation(QualifiedName.of((String)"count_if"), input.toSymbolReference(), (Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT);
            }
            case TOTAL_SIZE_IN_BYTES: {
                return this.createAggregation(QualifiedName.of((String)"$internal$sum_data_size_for_stats"), input.toSymbolReference(), inputType, (Type)BigintType.BIGINT);
            }
            case MAX_VALUE_SIZE_IN_BYTES: {
                return this.createAggregation(QualifiedName.of((String)"$internal$max_data_size_for_stats"), input.toSymbolReference(), inputType, (Type)BigintType.BIGINT);
            }
        }
        throw new IllegalArgumentException("Unsupported statistic type: " + statisticType);
    }

    private ColumnStatisticsAggregation createAggregation(QualifiedName functionName, SymbolReference input, Type inputType, Type outputType) {
        ResolvedFunction resolvedFunction = this.metadata.resolveFunction(functionName, TypeSignatureProvider.fromTypes(inputType));
        Type resolvedType = (Type)Iterables.getOnlyElement(resolvedFunction.getSignature().getArgumentTypes());
        Verify.verify((boolean)resolvedType.equals(inputType), (String)"resolved function input type does not match the input type: %s != %s", (Object)resolvedType, (Object)inputType);
        return new ColumnStatisticsAggregation(new AggregationNode.Aggregation(resolvedFunction, (List<Expression>)ImmutableList.of((Object)input), false, Optional.empty(), Optional.empty(), Optional.empty()), outputType);
    }

    public static class ColumnStatisticsAggregation {
        private final AggregationNode.Aggregation aggregation;
        private final Type outputType;

        private ColumnStatisticsAggregation(AggregationNode.Aggregation aggregation, Type outputType) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation is null");
            this.outputType = Objects.requireNonNull(outputType, "outputType is null");
        }

        public AggregationNode.Aggregation getAggregation() {
            return this.aggregation;
        }

        public Type getOutputType() {
            return this.outputType;
        }
    }

    public static class TableStatisticAggregation {
        private final StatisticAggregations aggregations;
        private final StatisticAggregationsDescriptor<Symbol> descriptor;

        private TableStatisticAggregation(StatisticAggregations aggregations, StatisticAggregationsDescriptor<Symbol> descriptor) {
            this.aggregations = Objects.requireNonNull(aggregations, "aggregations is null");
            this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        }

        public StatisticAggregations getAggregations() {
            return this.aggregations;
        }

        public StatisticAggregationsDescriptor<Symbol> getDescriptor() {
            return this.descriptor;
        }
    }
}

