/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.CachingCostProvider;
import io.trino.cost.CachingStatsProvider;
import io.trino.cost.CostCalculator;
import io.trino.cost.CostProvider;
import io.trino.cost.StatsAndCosts;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsProvider;
import io.trino.execution.warnings.WarningCollector;
import io.trino.matching.Capture;
import io.trino.matching.Match;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.GroupReference;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Memo;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.RuleIndex;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class IterativeOptimizer
implements PlanOptimizer {
    private static final Logger LOG = Logger.get(IterativeOptimizer.class);
    private final RuleStatsRecorder stats;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final List<PlanOptimizer> legacyRules;
    private final Set<Rule<?>> rules;
    private final RuleIndex ruleIndex;
    private final Predicate<Session> useLegacyRules;
    private final Metadata metadata;

    public IterativeOptimizer(Metadata metadata, RuleStatsRecorder stats, StatsCalculator statsCalculator, CostCalculator costCalculator, Set<Rule<?>> rules) {
        this(metadata, stats, statsCalculator, costCalculator, session -> false, (List<PlanOptimizer>)ImmutableList.of(), rules);
    }

    public IterativeOptimizer(Metadata metadata, RuleStatsRecorder stats, StatsCalculator statsCalculator, CostCalculator costCalculator, Predicate<Session> useLegacyRules, List<PlanOptimizer> legacyRules, Set<Rule<?>> newRules) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.useLegacyRules = Objects.requireNonNull(useLegacyRules, "useLegacyRules is null");
        this.rules = Objects.requireNonNull(newRules, "rules is null");
        this.legacyRules = ImmutableList.copyOf(legacyRules);
        this.ruleIndex = RuleIndex.builder().register(newRules).build();
        stats.registerAll(newRules);
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (this.useLegacyRules.test(session) && !this.legacyRules.isEmpty()) {
            for (PlanOptimizer optimizer : this.legacyRules) {
                plan = optimizer.optimize(plan, session, symbolAllocator.getTypes(), symbolAllocator, idAllocator, warningCollector);
            }
            return plan;
        }
        Memo memo = new Memo(idAllocator, plan);
        Lookup lookup = Lookup.from(planNode -> Stream.of(memo.resolve((GroupReference)planNode)));
        Duration timeout = SystemSessionProperties.getOptimizerTimeout(session);
        Context context = new Context(memo, lookup, idAllocator, symbolAllocator, System.nanoTime(), timeout.toMillis(), session, warningCollector);
        this.exploreGroup(memo.getRootGroup(), context);
        return memo.extract();
    }

    public Set<Rule<?>> getRules() {
        return this.rules;
    }

    private boolean exploreGroup(int group, Context context) {
        boolean progress = this.exploreNode(group, context);
        while (this.exploreChildren(group, context)) {
            progress = true;
            if (this.exploreNode(group, context)) continue;
            break;
        }
        return progress;
    }

    private boolean exploreNode(int group, Context context) {
        PlanNode node = context.memo.getNode(group);
        boolean done = false;
        boolean progress = false;
        while (!done) {
            context.checkTimeoutNotExhausted();
            done = true;
            Iterator possiblyMatchingRules = this.ruleIndex.getCandidates(node).iterator();
            while (possiblyMatchingRules.hasNext()) {
                Rule.Result result;
                Rule rule = (Rule)possiblyMatchingRules.next();
                if (!rule.isEnabled(context.session) || !(result = this.transform(node, rule, context)).getTransformedPlan().isPresent()) continue;
                node = context.memo.replace(group, result.getTransformedPlan().get(), rule.getClass().getName());
                done = false;
                progress = true;
            }
        }
        return progress;
    }

    private <T> Rule.Result transform(PlanNode node, Rule<T> rule, Context context) {
        Capture nodeCapture = Capture.newCapture();
        Pattern pattern = rule.getPattern().capturedAs(nodeCapture);
        Iterator matches = pattern.match((Object)node, (Object)context.lookup).iterator();
        while (matches.hasNext()) {
            long duration;
            Rule.Result result;
            Match match = (Match)matches.next();
            try {
                long start = System.nanoTime();
                result = rule.apply(match.capture(nodeCapture), match.captures(), this.ruleContext(context));
                if (LOG.isDebugEnabled() && !result.isEmpty()) {
                    LOG.debug("Rule: %s\nBefore:\n%s\nAfter:\n%s", new Object[]{rule.getClass().getName(), PlanPrinter.textLogicalPlan(node, context.symbolAllocator.getTypes(), this.metadata, StatsAndCosts.empty(), context.session, 0, false), PlanPrinter.textLogicalPlan(result.getTransformedPlan().get(), context.symbolAllocator.getTypes(), this.metadata, StatsAndCosts.empty(), context.session, 0, false)});
                }
                duration = System.nanoTime() - start;
            }
            catch (RuntimeException e) {
                this.stats.recordFailure(rule);
                throw e;
            }
            this.stats.record(rule, duration, !result.isEmpty());
            if (!result.getTransformedPlan().isPresent()) continue;
            return result;
        }
        return Rule.Result.empty();
    }

    private boolean exploreChildren(int group, Context context) {
        boolean progress = false;
        PlanNode expression = context.memo.getNode(group);
        for (PlanNode child : expression.getSources()) {
            Preconditions.checkState((boolean)(child instanceof GroupReference), (Object)("Expected child to be a group reference. Found: " + child.getClass().getName()));
            if (!this.exploreGroup(((GroupReference)child).getGroupId(), context)) continue;
            progress = true;
        }
        return progress;
    }

    private Rule.Context ruleContext(final Context context) {
        final CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator, Optional.of(context.memo), context.lookup, context.session, context.symbolAllocator.getTypes());
        final CachingCostProvider costProvider = new CachingCostProvider(this.costCalculator, statsProvider, Optional.of(context.memo), context.session, context.symbolAllocator.getTypes());
        return new Rule.Context(){

            @Override
            public Lookup getLookup() {
                return context.lookup;
            }

            @Override
            public PlanNodeIdAllocator getIdAllocator() {
                return context.idAllocator;
            }

            @Override
            public SymbolAllocator getSymbolAllocator() {
                return context.symbolAllocator;
            }

            @Override
            public Session getSession() {
                return context.session;
            }

            @Override
            public StatsProvider getStatsProvider() {
                return statsProvider;
            }

            @Override
            public CostProvider getCostProvider() {
                return costProvider;
            }

            @Override
            public void checkTimeoutNotExhausted() {
                context.checkTimeoutNotExhausted();
            }

            @Override
            public WarningCollector getWarningCollector() {
                return context.warningCollector;
            }
        };
    }

    private static class Context {
        private final Memo memo;
        private final Lookup lookup;
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final long startTimeInNanos;
        private final long timeoutInMilliseconds;
        private final Session session;
        private final WarningCollector warningCollector;

        public Context(Memo memo, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, long startTimeInNanos, long timeoutInMilliseconds, Session session, WarningCollector warningCollector) {
            Preconditions.checkArgument((timeoutInMilliseconds >= 0L ? 1 : 0) != 0, (Object)"Timeout has to be a non-negative number [milliseconds]");
            this.memo = memo;
            this.lookup = lookup;
            this.idAllocator = idAllocator;
            this.symbolAllocator = symbolAllocator;
            this.startTimeInNanos = startTimeInNanos;
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.session = session;
            this.warningCollector = warningCollector;
        }

        public void checkTimeoutNotExhausted() {
            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTimeInNanos) >= this.timeoutInMilliseconds) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.OPTIMIZER_TIMEOUT, String.format("The optimizer exhausted the time limit of %d ms", this.timeoutInMilliseconds));
            }
        }
    }
}

