/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.QualifiedName;
import java.util.Objects;

public class ImplementBernoulliSampleAsFilter
implements Rule<SampleNode> {
    private static final Pattern<SampleNode> PATTERN = Patterns.sample().with(Patterns.Sample.sampleType().equalTo((Object)SampleNode.Type.BERNOULLI));
    private final Metadata metadata;

    public ImplementBernoulliSampleAsFilter(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<SampleNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(SampleNode sample, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(new FilterNode(sample.getId(), sample.getSource(), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"rand")).build(), (Expression)new DoubleLiteral(Double.toString(sample.getSampleRatio())))));
    }
}

