/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.FunctionId;
import io.trino.metadata.Metadata;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.ChildReplacer;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PushdownLimitIntoWindow
implements Rule<LimitNode> {
    private static final Capture<WindowNode> childCapture = Capture.newCapture();
    private final Pattern<LimitNode> pattern;
    private final FunctionId rowNumberFunctionId;
    private final FunctionId rankFunctionId;

    public PushdownLimitIntoWindow(Metadata metadata) {
        this.rowNumberFunctionId = metadata.resolveFunction(QualifiedName.of((String)"row_number"), (List<TypeSignatureProvider>)ImmutableList.of()).getFunctionId();
        this.rankFunctionId = metadata.resolveFunction(QualifiedName.of((String)"rank"), (List<TypeSignatureProvider>)ImmutableList.of()).getFunctionId();
        this.pattern = Patterns.limit().matching(limit -> !limit.isWithTies() && limit.getCount() != 0L && limit.getCount() <= Integer.MAX_VALUE && !limit.requiresPreSortedInputs()).with(Patterns.source().matching(Patterns.window().matching(window -> window.getOrderingScheme().isPresent()).matching(window -> this.toTopNRankingType((WindowNode)window).isPresent()).capturedAs(childCapture)));
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isOptimizeTopNRanking(session);
    }

    @Override
    public Pattern<LimitNode> getPattern() {
        return this.pattern;
    }

    @Override
    public Rule.Result apply(LimitNode node, Captures captures, Rule.Context context) {
        WindowNode source = (WindowNode)captures.get(childCapture);
        Optional<TopNRankingNode.RankingType> rankingType = this.toTopNRankingType(source);
        int limit = Math.toIntExact(node.getCount());
        TopNRankingNode topNRowNumberNode = new TopNRankingNode(source.getId(), source.getSource(), source.getSpecification(), rankingType.get(), (Symbol)Iterables.getOnlyElement(source.getWindowFunctions().keySet()), limit, false, Optional.empty());
        if (rankingType.get() == TopNRankingNode.RankingType.ROW_NUMBER && source.getPartitionBy().isEmpty()) {
            return Rule.Result.ofPlanNode(topNRowNumberNode);
        }
        return Rule.Result.ofPlanNode(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)topNRowNumberNode)));
    }

    private Optional<TopNRankingNode.RankingType> toTopNRankingType(WindowNode node) {
        if (node.getWindowFunctions().size() != 1 || node.getOrderingScheme().isEmpty()) {
            return Optional.empty();
        }
        Symbol rankingSymbol = (Symbol)((Map.Entry)Iterables.getOnlyElement(node.getWindowFunctions().entrySet())).getKey();
        FunctionId functionId = node.getWindowFunctions().get(rankingSymbol).getResolvedFunction().getFunctionId();
        if (functionId.equals(this.rowNumberFunctionId)) {
            return Optional.of(TopNRankingNode.RankingType.ROW_NUMBER);
        }
        if (functionId.equals(this.rankFunctionId)) {
            return Optional.of(TopNRankingNode.RankingType.RANK);
        }
        return Optional.empty();
    }
}

