/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.FunctionId;
import io.trino.metadata.Metadata;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Optional;

public class ReplaceWindowWithRowNumber
implements Rule<WindowNode> {
    private final Pattern<WindowNode> pattern;

    public ReplaceWindowWithRowNumber(Metadata metadata) {
        FunctionId rowNumber = metadata.resolveFunction(QualifiedName.of((String)"row_number"), (List<TypeSignatureProvider>)ImmutableList.of()).getFunctionId();
        this.pattern = Patterns.window().matching(window -> window.getWindowFunctions().size() == 1 && ((WindowNode.Function)Iterables.getOnlyElement(window.getWindowFunctions().values())).getResolvedFunction().getFunctionId().equals(rowNumber)).matching(window -> window.getOrderingScheme().isEmpty());
    }

    @Override
    public Pattern<WindowNode> getPattern() {
        return this.pattern;
    }

    @Override
    public Rule.Result apply(WindowNode node, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(new RowNumberNode(node.getId(), node.getSource(), node.getPartitionBy(), false, (Symbol)Iterables.getOnlyElement(node.getWindowFunctions().keySet()), Optional.empty(), Optional.empty()));
    }
}

