/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TransformCorrelatedScalarSubquery
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Pattern.nonEmpty(Patterns.CorrelatedJoin.correlation())).with(Patterns.CorrelatedJoin.filter().equalTo((Object)BooleanLiteral.TRUE_LITERAL));
    private final Metadata metadata;

    public TransformCorrelatedScalarSubquery(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        PlanNode subquery = context.getLookup().resolve(correlatedJoinNode.getSubquery());
        if (!PlanNodeSearcher.searchFrom(subquery, context.getLookup()).where(EnforceSingleRowNode.class::isInstance).recurseOnlyWhen(ProjectNode.class::isInstance).matches()) {
            return Rule.Result.empty();
        }
        PlanNode rewrittenSubquery = PlanNodeSearcher.searchFrom(subquery, context.getLookup()).where(EnforceSingleRowNode.class::isInstance).recurseOnlyWhen(ProjectNode.class::isInstance).removeFirst();
        Range<Long> subqueryCardinality = QueryCardinalityUtil.extractCardinality(rewrittenSubquery, context.getLookup());
        boolean producesAtMostOneRow = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(1L)).encloses(subqueryCardinality);
        if (producesAtMostOneRow) {
            boolean producesSingleRow = Range.singleton((Comparable)Long.valueOf(1L)).encloses(subqueryCardinality);
            return Rule.Result.ofPlanNode(new CorrelatedJoinNode(context.getIdAllocator().getNextId(), correlatedJoinNode.getInput(), rewrittenSubquery, correlatedJoinNode.getCorrelation(), producesSingleRow ? correlatedJoinNode.getType() : CorrelatedJoinNode.Type.LEFT, correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery()));
        }
        Symbol unique = context.getSymbolAllocator().newSymbol("unique", (Type)BigintType.BIGINT);
        CorrelatedJoinNode rewrittenCorrelatedJoinNode = new CorrelatedJoinNode(context.getIdAllocator().getNextId(), new AssignUniqueId(context.getIdAllocator().getNextId(), correlatedJoinNode.getInput(), unique), rewrittenSubquery, correlatedJoinNode.getCorrelation(), CorrelatedJoinNode.Type.LEFT, correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery());
        Symbol isDistinct = context.getSymbolAllocator().newSymbol("is_distinct", (Type)BooleanType.BOOLEAN);
        MarkDistinctNode markDistinctNode = new MarkDistinctNode(context.getIdAllocator().getNextId(), rewrittenCorrelatedJoinNode, isDistinct, rewrittenCorrelatedJoinNode.getInput().getOutputSymbols(), Optional.empty());
        FilterNode filterNode = new FilterNode(context.getIdAllocator().getNextId(), markDistinctNode, (Expression)new SimpleCaseExpression((Expression)isDistinct.toSymbolReference(), (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(new Cast((Expression)new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"fail")).addArgument((Type)IntegerType.INTEGER, (Expression)new LongLiteral(Integer.toString(StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.toErrorCode().getCode()))).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral("Scalar sub-query has returned multiple rows")).build(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)))));
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), filterNode, Assignments.identity(correlatedJoinNode.getOutputSymbols())));
    }
}

