/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.tree.Expression;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StatisticAggregations {
    private final Map<Symbol, AggregationNode.Aggregation> aggregations;
    private final List<Symbol> groupingSymbols;

    @JsonCreator
    public StatisticAggregations(@JsonProperty(value="aggregations") Map<Symbol, AggregationNode.Aggregation> aggregations, @JsonProperty(value="groupingSymbols") List<Symbol> groupingSymbols) {
        this.aggregations = ImmutableMap.copyOf(Objects.requireNonNull(aggregations, "aggregations is null"));
        this.groupingSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingSymbols, "groupingSymbols is null"));
    }

    @JsonProperty
    public Map<Symbol, AggregationNode.Aggregation> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty
    public List<Symbol> getGroupingSymbols() {
        return this.groupingSymbols;
    }

    public Parts createPartialAggregations(SymbolAllocator symbolAllocator, Metadata metadata) {
        ImmutableMap.Builder partialAggregation = ImmutableMap.builder();
        ImmutableMap.Builder finalAggregation = ImmutableMap.builder();
        ImmutableMap.Builder mappings = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : this.aggregations.entrySet()) {
            AggregationNode.Aggregation originalAggregation = entry.getValue();
            ResolvedFunction resolvedFunction = originalAggregation.getResolvedFunction();
            AggregationFunctionMetadata functionMetadata = metadata.getAggregationFunctionMetadata(resolvedFunction);
            Type intermediateType = metadata.getType(functionMetadata.getIntermediateType().orElseThrow(() -> new IllegalArgumentException("aggregation is not decomposable")));
            Symbol partialSymbol = symbolAllocator.newSymbol(resolvedFunction.getSignature().getName(), intermediateType);
            mappings.put((Object)entry.getKey(), (Object)partialSymbol);
            partialAggregation.put((Object)partialSymbol, (Object)new AggregationNode.Aggregation(resolvedFunction, originalAggregation.getArguments(), originalAggregation.isDistinct(), originalAggregation.getFilter(), originalAggregation.getOrderingScheme(), originalAggregation.getMask()));
            finalAggregation.put((Object)entry.getKey(), (Object)new AggregationNode.Aggregation(resolvedFunction, (List<Expression>)ImmutableList.of((Object)partialSymbol.toSymbolReference()), false, Optional.empty(), Optional.empty(), Optional.empty()));
        }
        this.groupingSymbols.forEach(symbol -> mappings.put(symbol, symbol));
        return new Parts(new StatisticAggregations((Map<Symbol, AggregationNode.Aggregation>)partialAggregation.build(), this.groupingSymbols), new StatisticAggregations((Map<Symbol, AggregationNode.Aggregation>)finalAggregation.build(), this.groupingSymbols), (Map<Symbol, Symbol>)mappings.build());
    }

    public static class Parts {
        private final StatisticAggregations partialAggregation;
        private final StatisticAggregations finalAggregation;
        private final Map<Symbol, Symbol> mappings;

        public Parts(StatisticAggregations partialAggregation, StatisticAggregations finalAggregation, Map<Symbol, Symbol> mappings) {
            this.partialAggregation = Objects.requireNonNull(partialAggregation, "partialAggregation is null");
            this.finalAggregation = Objects.requireNonNull(finalAggregation, "finalAggregation is null");
            this.mappings = ImmutableMap.copyOf(Objects.requireNonNull(mappings, "mappings is null"));
        }

        public StatisticAggregations getPartialAggregation() {
            return this.partialAggregation;
        }

        public StatisticAggregations getFinalAggregation() {
            return this.finalAggregation;
        }

        public Map<Symbol, Symbol> getMappings() {
            return this.mappings;
        }
    }
}

