/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.spi.connector.ConstantProperty;
import io.trino.spi.connector.SortingProperty;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.LocalProperties;
import io.trino.sql.planner.optimizations.StreamPropertyDerivations;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import java.util.List;

public class ValidateLimitWithPresortedInput
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, TypeOperators typeOperators, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        planNode.accept(new Visitor(session, metadata, typeOperators, typeAnalyzer, types), null);
    }

    private static final class Visitor
    extends PlanVisitor<Void, Void> {
        private final Session session;
        private final Metadata metadata;
        private final TypeOperators typeOperators;
        private final TypeAnalyzer typeAnalyzer;
        private final TypeProvider types;

        private Visitor(Session session, Metadata metadata, TypeOperators typeOperators, TypeAnalyzer typeAnalyzer, TypeProvider types) {
            this.session = session;
            this.metadata = metadata;
            this.typeOperators = typeOperators;
            this.typeAnalyzer = typeAnalyzer;
            this.types = types;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            node.getSources().forEach(source -> source.accept(this, context));
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            if (node.getPreSortedInputs().isEmpty()) {
                return null;
            }
            StreamPropertyDerivations.StreamProperties properties = StreamPropertyDerivations.derivePropertiesRecursively(node.getSource(), this.metadata, this.typeOperators, this.session, this.types, this.typeAnalyzer);
            List sortedColumns = (List)LocalProperties.normalizeAndPrune(properties.getLocalProperties()).stream().filter(property -> property instanceof SortingProperty || property instanceof ConstantProperty).flatMap(property -> property.getColumns().stream()).collect(ImmutableList.toImmutableList());
            if (sortedColumns.size() < node.getPreSortedInputs().size() || !sortedColumns.subList(0, node.getPreSortedInputs().size()).equals(node.getPreSortedInputs())) {
                throw new VerifyException(String.format("Expected Limit input to be sorted by: %s, but was %s", node.getPreSortedInputs(), sortedColumns));
            }
            return null;
        }
    }
}

