/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.rewrite;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.StatsCalculator;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.type.FixedWidthType;
import io.trino.sql.ParsingUtil;
import io.trino.sql.QueryUtil;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.DescribeOutput;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.type.TypeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class DescribeOutputRewrite
implements StatementRewrite.Rewrite {
    DescribeOutputRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, GroupProvider groupProvider, AccessControl accessControl, WarningCollector warningCollector, StatsCalculator statsCalculator) {
        return (Statement)new Visitor(session, parser, metadata, queryExplainer, parameters, parameterLookup, groupProvider, accessControl, warningCollector, statsCalculator).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final SqlParser parser;
        private final Metadata metadata;
        private final Optional<QueryExplainer> queryExplainer;
        private final List<Expression> parameters;
        private final Map<NodeRef<Parameter>, Expression> parameterLookup;
        private final GroupProvider groupProvider;
        private final AccessControl accessControl;
        private final WarningCollector warningCollector;
        private final StatsCalculator statsCalculator;

        public Visitor(Session session, SqlParser parser, Metadata metadata, Optional<QueryExplainer> queryExplainer, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, GroupProvider groupProvider, AccessControl accessControl, WarningCollector warningCollector, StatsCalculator statsCalculator) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.parser = parser;
            this.metadata = metadata;
            this.queryExplainer = queryExplainer;
            this.parameters = parameters;
            this.parameterLookup = parameterLookup;
            this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
            this.accessControl = accessControl;
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        }

        protected Node visitDescribeOutput(DescribeOutput node, Void context) {
            String sqlString = this.session.getPreparedStatement(node.getName().getValue());
            Statement statement = this.parser.createStatement(sqlString, ParsingUtil.createParsingOptions(this.session));
            Analyzer analyzer = new Analyzer(this.session, this.metadata, this.parser, this.groupProvider, this.accessControl, this.queryExplainer, this.parameters, this.parameterLookup, this.warningCollector, this.statsCalculator);
            Analysis analysis = analyzer.analyze(statement, true);
            Optional<Object> limit = Optional.empty();
            Row[] rows = (Row[])analysis.getRootScope().getRelationType().getVisibleFields().stream().map(field -> this.createDescribeOutputRow((Field)field, analysis)).toArray(Row[]::new);
            if (rows.length == 0) {
                NullLiteral nullLiteral = new NullLiteral();
                rows = new Row[]{QueryUtil.row((Expression[])new Expression[]{nullLiteral, nullLiteral, nullLiteral, nullLiteral, nullLiteral, nullLiteral, nullLiteral})};
                limit = Optional.of(new Limit((Expression)new LongLiteral("0")));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"Column Name"), QueryUtil.identifier((String)"Catalog"), QueryUtil.identifier((String)"Schema"), QueryUtil.identifier((String)"Table"), QueryUtil.identifier((String)"Type"), QueryUtil.identifier((String)"Type Size"), QueryUtil.identifier((String)"Aliased")}), (Relation)QueryUtil.aliased((Relation)QueryUtil.values((Row[])rows), (String)"Statement Output", (List)ImmutableList.of((Object)"Column Name", (Object)"Catalog", (Object)"Schema", (Object)"Table", (Object)"Type", (Object)"Type Size", (Object)"Aliased")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), limit);
        }

        private Row createDescribeOutputRow(Field field, Analysis analysis) {
            Object columnName;
            LongLiteral typeSize = new LongLiteral("0");
            if (field.getType() instanceof FixedWidthType) {
                typeSize = new LongLiteral(String.valueOf(((FixedWidthType)field.getType()).getFixedSize()));
            }
            if (field.getName().isPresent()) {
                columnName = field.getName().get();
            } else {
                int columnIndex = ImmutableList.copyOf(analysis.getOutputDescriptor().getVisibleFields()).indexOf((Object)field);
                columnName = "_col" + columnIndex;
            }
            Optional<QualifiedObjectName> originTable = field.getOriginTable();
            return QueryUtil.row((Expression[])new Expression[]{new StringLiteral((String)columnName), new StringLiteral(originTable.map(QualifiedObjectName::getCatalogName).orElse("")), new StringLiteral(originTable.map(QualifiedObjectName::getSchemaName).orElse("")), new StringLiteral(originTable.map(QualifiedObjectName::getObjectName).orElse("")), new StringLiteral(TypeUtils.getDisplayLabel(field.getType(), SystemSessionProperties.isOmitDateTimeTypePrecision(this.session))), typeSize, new BooleanLiteral(String.valueOf(field.isAliased()))});
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

