/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class DropTableTask
implements DataDefinitionTask<DropTable> {
    @Override
    public String getName() {
        return "DROP TABLE";
    }

    @Override
    public ListenableFuture<Void> execute(DropTable statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        Optional<ConnectorMaterializedViewDefinition> materializedView = metadata.getMaterializedView(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTableName()));
        if (materializedView.isPresent()) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist, but a materialized view with that name exists. Did you mean DROP MATERIALIZED VIEW %s?", tableName, tableName);
            }
            return Futures.immediateVoidFuture();
        }
        Optional<ConnectorViewDefinition> view = metadata.getView(session, tableName);
        if (view.isPresent()) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist, but a view with that name exists. Did you mean DROP VIEW %s?", tableName, tableName);
            }
            return Futures.immediateVoidFuture();
        }
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
        if (tableHandle.isEmpty()) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
            }
            return Futures.immediateVoidFuture();
        }
        accessControl.checkCanDropTable(session.toSecurityContext(), tableName);
        metadata.dropTable(session, tableHandle.get());
        return Futures.immediateVoidFuture();
    }
}

