/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class DropViewTask
implements DataDefinitionTask<DropView> {
    @Override
    public String getName() {
        return "DROP VIEW";
    }

    @Override
    public ListenableFuture<Void> execute(DropView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName name;
        Session session = stateMachine.getSession();
        Optional<ConnectorMaterializedViewDefinition> materializedView = metadata.getMaterializedView(session, name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName()));
        if (materializedView.isPresent()) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist, but a materialized view with that name exists. Did you mean DROP MATERIALIZED VIEW %s?", name, name);
            }
            return Futures.immediateVoidFuture();
        }
        Optional<ConnectorViewDefinition> view = metadata.getView(session, name);
        if (view.isEmpty()) {
            if (!statement.isExists()) {
                Optional<TableHandle> table = metadata.getTableHandle(session, name);
                if (table.isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist, but a table with that name exists. Did you mean DROP TABLE %s?", name, name);
                }
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist", name);
            }
            return Futures.immediateVoidFuture();
        }
        accessControl.checkCanDropView(session.toSecurityContext(), name);
        metadata.dropView(session, name);
        return Futures.immediateVoidFuture();
    }
}

