/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.security.Privilege;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Grant;
import io.trino.sql.tree.GrantOnType;
import io.trino.sql.tree.Node;
import io.trino.transaction.TransactionManager;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class GrantTask
implements DataDefinitionTask<Grant> {
    @Override
    public String getName() {
        return "GRANT";
    }

    @Override
    public ListenableFuture<Void> execute(Grant statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        if (statement.getType().filter(arg_0 -> GrantOnType.SCHEMA.equals(arg_0)).isPresent()) {
            this.executeGrantOnSchema(stateMachine.getSession(), statement, metadata, accessControl);
        } else {
            this.executeGrantOnTable(stateMachine.getSession(), statement, metadata, accessControl);
        }
        return Futures.immediateVoidFuture();
    }

    private void executeGrantOnSchema(Session session, Grant statement, Metadata metadata, AccessControl accessControl) {
        CatalogSchemaName schemaName = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getName()));
        if (!metadata.schemaExists(session, schemaName)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)statement, "Schema '%s' does not exist", schemaName);
        }
        Set<Privilege> privileges = GrantTask.parseStatementPrivileges(statement);
        for (Privilege privilege : privileges) {
            accessControl.checkCanGrantSchemaPrivilege(session.toSecurityContext(), privilege, schemaName, MetadataUtil.createPrincipal(statement.getGrantee()), statement.isWithGrantOption());
        }
        metadata.grantSchemaPrivileges(session, schemaName, privileges, MetadataUtil.createPrincipal(statement.getGrantee()), statement.isWithGrantOption());
    }

    private void executeGrantOnTable(Session session, Grant statement, Metadata metadata, AccessControl accessControl) {
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
        if (tableHandle.isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
        }
        Set<Privilege> privileges = GrantTask.parseStatementPrivileges(statement);
        for (Privilege privilege : privileges) {
            accessControl.checkCanGrantTablePrivilege(session.toSecurityContext(), privilege, tableName, MetadataUtil.createPrincipal(statement.getGrantee()), statement.isWithGrantOption());
        }
        metadata.grantTablePrivileges(session, tableName, privileges, MetadataUtil.createPrincipal(statement.getGrantee()), statement.isWithGrantOption());
    }

    private static Set<Privilege> parseStatementPrivileges(Grant statement) {
        Set<Object> privileges = statement.getPrivileges().isPresent() ? (Set)((List)statement.getPrivileges().get()).stream().map(privilege -> GrantTask.parsePrivilege(statement, privilege)).collect(ImmutableSet.toImmutableSet()) : EnumSet.allOf(Privilege.class);
        return privileges;
    }

    private static Privilege parsePrivilege(Grant statement, String privilegeString) {
        for (Privilege privilege : Privilege.values()) {
            if (!privilege.name().equalsIgnoreCase(privilegeString)) continue;
            return privilege;
        }
        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PRIVILEGE, (Node)statement, "Unknown privilege: '%s'", privilegeString);
    }
}

