/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.RenameView;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class RenameViewTask
implements DataDefinitionTask<RenameView> {
    @Override
    public String getName() {
        return "RENAME VIEW";
    }

    @Override
    public ListenableFuture<Void> execute(RenameView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName viewName;
        Session session = stateMachine.getSession();
        Optional<ConnectorMaterializedViewDefinition> materializedView = metadata.getMaterializedView(session, viewName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource()));
        if (materializedView.isPresent()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist, but a materialized view with that name exists.", viewName);
        }
        Optional<ConnectorViewDefinition> viewDefinition = metadata.getView(session, viewName);
        if (viewDefinition.isEmpty()) {
            Optional<TableHandle> table = metadata.getTableHandle(session, viewName);
            if (table.isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist, but a table with that name exists. Did you mean ALTER TABLE %s RENAME ...?", viewName, viewName);
            }
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist", viewName);
        }
        QualifiedObjectName target = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTarget());
        if (metadata.getCatalogHandle(session, target.getCatalogName()).isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)statement, "Target catalog '%s' does not exist", target.getCatalogName());
        }
        if (metadata.getView(session, target).isPresent()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Target view '%s' already exists", target);
        }
        if (!viewName.getCatalogName().equals(target.getCatalogName())) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "View rename across catalogs is not supported", new Object[0]);
        }
        accessControl.checkCanRenameView(session.toSecurityContext(), viewName, target);
        metadata.renameView(session, viewName, target);
        return Futures.immediateVoidFuture();
    }
}

