/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetTableAuthorization;
import io.trino.transaction.TransactionManager;
import java.util.List;

public class SetTableAuthorizationTask
implements DataDefinitionTask<SetTableAuthorization> {
    @Override
    public String getName() {
        return "SET TABLE AUTHORIZATION";
    }

    @Override
    public ListenableFuture<Void> execute(SetTableAuthorization statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource());
        CatalogName catalogName = metadata.getCatalogHandle(session, tableName.getCatalogName()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + tableName.getCatalogName()));
        if (metadata.getTableHandle(session, tableName).isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
        }
        TrinoPrincipal principal = MetadataUtil.createPrincipal(statement.getPrincipal());
        if (principal.getType() == PrincipalType.ROLE && !metadata.listRoles(session, catalogName.getCatalogName()).contains(principal.getName())) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND, (Node)statement, "Role '%s' does not exist", principal.getName());
        }
        accessControl.checkCanSetTableAuthorization(session.toSecurityContext(), tableName, principal);
        metadata.setTableAuthorization(session, tableName.asCatalogSchemaTableName(), principal);
        return Futures.immediateVoidFuture();
    }
}

