/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.SetThreadName;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogName;
import io.trino.cost.CostCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.execution.ForQueryExecution;
import io.trino.execution.Input;
import io.trino.execution.MemoryTrackingRemoteTaskFactory;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.QueryExecution;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.QueryPreparer;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.StageId;
import io.trino.execution.StageInfo;
import io.trino.execution.StateMachine;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.scheduler.ExecutionPolicy;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.execution.scheduler.SqlQueryScheduler;
import io.trino.execution.warnings.WarningCollector;
import io.trino.failuredetector.FailureDetector;
import io.trino.memory.VersionedMemoryPoolId;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.operator.ForScheduler;
import io.trino.security.AccessControl;
import io.trino.server.BasicQueryInfo;
import io.trino.server.DynamicFilterService;
import io.trino.server.protocol.Slug;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.type.TypeOperators;
import io.trino.split.SplitManager;
import io.trino.split.SplitSource;
import io.trino.sql.ParameterUtils;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.DistributedExecutionPlanner;
import io.trino.sql.planner.InputExtractor;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.StageExecutionPlan;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.joda.time.DateTime;

@ThreadSafe
public class SqlQueryExecution
implements QueryExecution {
    private static final Logger log = Logger.get(SqlQueryExecution.class);
    private static final OutputBuffers.OutputBufferId OUTPUT_BUFFER_ID = new OutputBuffers.OutputBufferId(0);
    private final QueryStateMachine stateMachine;
    private final Slug slug;
    private final Metadata metadata;
    private final TypeOperators typeOperators;
    private final SqlParser sqlParser;
    private final SplitManager splitManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final NodeScheduler nodeScheduler;
    private final List<PlanOptimizer> planOptimizers;
    private final PlanFragmenter planFragmenter;
    private final RemoteTaskFactory remoteTaskFactory;
    private final int scheduleSplitBatchSize;
    private final ExecutorService queryExecutor;
    private final ScheduledExecutorService schedulerExecutor;
    private final FailureDetector failureDetector;
    private final AtomicReference<SqlQueryScheduler> queryScheduler = new AtomicReference();
    private final AtomicReference<Plan> queryPlan = new AtomicReference();
    private final NodeTaskMap nodeTaskMap;
    private final ExecutionPolicy executionPolicy;
    private final SplitSchedulerStats schedulerStats;
    private final Analysis analysis;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final DynamicFilterService dynamicFilterService;

    private SqlQueryExecution(QueryPreparer.PreparedQuery preparedQuery, QueryStateMachine stateMachine, Slug slug, Metadata metadata, TypeOperators typeOperators, GroupProvider groupProvider, AccessControl accessControl, SqlParser sqlParser, SplitManager splitManager, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, List<PlanOptimizer> planOptimizers, PlanFragmenter planFragmenter, RemoteTaskFactory remoteTaskFactory, int scheduleSplitBatchSize, ExecutorService queryExecutor, ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, NodeTaskMap nodeTaskMap, QueryExplainer queryExplainer, ExecutionPolicy executionPolicy, SplitSchedulerStats schedulerStats, StatsCalculator statsCalculator, CostCalculator costCalculator, DynamicFilterService dynamicFilterService, WarningCollector warningCollector) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{stateMachine.getQueryId()});){
            this.slug = Objects.requireNonNull(slug, "slug is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
            this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
            this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
            this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
            this.schedulerExecutor = Objects.requireNonNull(schedulerExecutor, "schedulerExecutor is null");
            this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
            this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
            this.executionPolicy = Objects.requireNonNull(executionPolicy, "executionPolicy is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
            this.dynamicFilterService = Objects.requireNonNull(dynamicFilterService, "dynamicFilterService is null");
            Preconditions.checkArgument((scheduleSplitBatchSize > 0 ? 1 : 0) != 0, (Object)"scheduleSplitBatchSize must be greater than 0");
            this.scheduleSplitBatchSize = scheduleSplitBatchSize;
            this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
            this.analysis = this.analyze(preparedQuery, stateMachine, metadata, groupProvider, accessControl, sqlParser, queryExplainer, warningCollector);
            stateMachine.addStateChangeListener(state -> {
                if (!state.isDone()) {
                    return;
                }
                this.unregisterDynamicFilteringQuery(dynamicFilterService.getDynamicFilteringStats(stateMachine.getQueryId(), stateMachine.getSession()));
            });
            AtomicReference<SqlQueryScheduler> queryScheduler = this.queryScheduler;
            stateMachine.addStateChangeListener(state -> {
                if (!state.isDone()) {
                    return;
                }
                SqlQueryScheduler scheduler = (SqlQueryScheduler)queryScheduler.get();
                if (scheduler != null) {
                    scheduler.abort();
                }
            });
            this.remoteTaskFactory = new MemoryTrackingRemoteTaskFactory(Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null"), stateMachine);
        }
    }

    private synchronized void registerDynamicFilteringQuery(PlanRoot plan) {
        if (!SystemSessionProperties.isEnableDynamicFiltering(this.stateMachine.getSession())) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        this.dynamicFilterService.registerQuery(this, plan.getRoot());
        this.stateMachine.setDynamicFiltersStatsSupplier(() -> this.dynamicFilterService.getDynamicFilteringStats(this.stateMachine.getQueryId(), this.stateMachine.getSession()));
    }

    private synchronized void unregisterDynamicFilteringQuery(DynamicFilterService.DynamicFiltersStats finalDynamicFiltersStats) {
        Preconditions.checkState((boolean)this.isDone(), (Object)"Expected query to be in done state");
        this.stateMachine.setDynamicFiltersStatsSupplier(() -> finalDynamicFiltersStats);
        this.dynamicFilterService.removeQuery(this.stateMachine.getQueryId());
    }

    private Analysis analyze(QueryPreparer.PreparedQuery preparedQuery, QueryStateMachine stateMachine, Metadata metadata, GroupProvider groupProvider, AccessControl accessControl, SqlParser sqlParser, QueryExplainer queryExplainer, WarningCollector warningCollector) {
        Analysis analysis;
        stateMachine.beginAnalysis();
        Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        Analyzer analyzer = new Analyzer(stateMachine.getSession(), metadata, sqlParser, groupProvider, accessControl, Optional.of(queryExplainer), preparedQuery.getParameters(), ParameterUtils.parameterExtractor(preparedQuery.getStatement(), preparedQuery.getParameters()), warningCollector, this.statsCalculator);
        try {
            analysis = analyzer.analyze(preparedQuery.getStatement());
        }
        catch (StackOverflowError e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "statement is too large (stack overflow during analysis)", (Throwable)e);
        }
        stateMachine.setUpdateType(analysis.getUpdateType());
        stateMachine.setReferencedTables(analysis.getReferencedTables());
        stateMachine.setRoutines(analysis.getRoutines());
        stateMachine.endAnalysis();
        return analysis;
    }

    @Override
    public Slug getSlug() {
        return this.slug;
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.stateMachine.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.stateMachine.setMemoryPool(poolId);
    }

    @Override
    public DataSize getUserMemoryReservation() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getUserMemoryReservation();
        }
        if (scheduler == null) {
            return DataSize.ofBytes((long)0L);
        }
        return DataSize.succinctBytes((long)scheduler.getUserMemoryReservation());
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalMemoryReservation();
        }
        if (scheduler == null) {
            return DataSize.ofBytes((long)0L);
        }
        return DataSize.succinctBytes((long)scheduler.getTotalMemoryReservation());
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public Optional<Duration> getPlanningTime() {
        return this.stateMachine.getPlanningTime();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public Duration getTotalCpuTime() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalCpuTime();
        }
        if (scheduler == null) {
            return new Duration(0.0, TimeUnit.SECONDS);
        }
        return scheduler.getTotalCpuTime();
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().map(BasicQueryInfo::new).orElseGet(() -> this.stateMachine.getBasicQueryInfo(Optional.ofNullable(this.queryScheduler.get()).map(SqlQueryScheduler::getBasicStageStats)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        SetThreadName ignored;
        block21: {
            Object plan;
            block19: {
                ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});
                if (this.stateMachine.transitionToPlanning()) break block19;
                ignored.close();
                return;
            }
            AtomicReference<Thread> planningThread = new AtomicReference<Thread>(Thread.currentThread());
            this.stateMachine.getStateChange(QueryState.PLANNING).addListener(() -> {
                if (this.stateMachine.getQueryState() == QueryState.FAILED) {
                    SqlQueryExecution sqlQueryExecution = this;
                    synchronized (sqlQueryExecution) {
                        Thread thread = (Thread)planningThread.get();
                        if (thread != null) {
                            thread.interrupt();
                        }
                    }
                }
            }, MoreExecutors.directExecutor());
            try {
                plan = this.planQuery();
                this.registerDynamicFilteringQuery((PlanRoot)plan);
                this.planDistribution((PlanRoot)plan);
            }
            finally {
                plan = this;
                synchronized (plan) {
                    planningThread.set(null);
                    Thread.interrupted();
                }
            }
            if (this.stateMachine.transitionToStarting()) break block21;
            ignored.close();
            return;
        }
        try {
            try {
                SqlQueryScheduler scheduler = this.queryScheduler.get();
                if (!this.stateMachine.isDone()) {
                    scheduler.start();
                }
            }
            catch (Throwable e) {
                this.fail(e);
                Throwables.throwIfInstanceOf((Throwable)e, Error.class);
            }
        }
        finally {
            ignored.close();
        }
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            this.stateMachine.addStateChangeListener(stateChangeListener);
        }
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.stateMachine.addQueryInfoStateChangeListener(stateChangeListener);
    }

    private PlanRoot planQuery() {
        try {
            return this.doPlanQuery();
        }
        catch (StackOverflowError e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "statement is too large (stack overflow during analysis)", (Throwable)e);
        }
    }

    private PlanRoot doPlanQuery() {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(this.stateMachine.getSession(), this.planOptimizers, idAllocator, this.metadata, this.typeOperators, new TypeAnalyzer(this.sqlParser, this.metadata), this.statsCalculator, this.costCalculator, this.stateMachine.getWarningCollector());
        Plan plan = logicalPlanner.plan(this.analysis);
        this.queryPlan.set(plan);
        SubPlan fragmentedPlan = this.planFragmenter.createSubPlans(this.stateMachine.getSession(), plan, false, this.stateMachine.getWarningCollector());
        List<Input> inputs = new InputExtractor(this.metadata, this.stateMachine.getSession()).extractInputs(fragmentedPlan);
        this.stateMachine.setInputs(inputs);
        this.stateMachine.setOutput(this.analysis.getTarget());
        boolean explainAnalyze = this.analysis.getStatement() instanceof ExplainAnalyze;
        return new PlanRoot(fragmentedPlan, !explainAnalyze);
    }

    private void planDistribution(PlanRoot plan) {
        DistributedExecutionPlanner distributedPlanner = new DistributedExecutionPlanner(this.splitManager, this.metadata, this.dynamicFilterService);
        StageExecutionPlan outputStageExecutionPlan = distributedPlanner.plan(plan.getRoot(), this.stateMachine.getSession());
        this.stateMachine.addStateChangeListener(state -> {
            if (state.isDone()) {
                SqlQueryExecution.closeSplitSources(outputStageExecutionPlan);
            }
        });
        if (this.stateMachine.isDone()) {
            return;
        }
        this.stateMachine.setColumns(outputStageExecutionPlan.getFieldNames(), outputStageExecutionPlan.getFragment().getTypes());
        PartitioningHandle partitioningHandle = plan.getRoot().getFragment().getPartitioningScheme().getPartitioning().getHandle();
        OutputBuffers rootOutputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(partitioningHandle).withBuffer(OUTPUT_BUFFER_ID, 0).withNoMoreBufferIds();
        SqlQueryScheduler scheduler = SqlQueryScheduler.createSqlQueryScheduler(this.stateMachine, outputStageExecutionPlan, this.nodePartitioningManager, this.nodeScheduler, this.remoteTaskFactory, this.stateMachine.getSession(), plan.isSummarizeTaskInfos(), this.scheduleSplitBatchSize, this.queryExecutor, this.schedulerExecutor, this.failureDetector, rootOutputBuffers, this.nodeTaskMap, this.executionPolicy, this.schedulerStats, this.dynamicFilterService);
        this.queryScheduler.set(scheduler);
        if (this.stateMachine.isDone()) {
            scheduler.abort();
            this.queryScheduler.set(null);
        }
    }

    private static void closeSplitSources(StageExecutionPlan plan) {
        for (SplitSource source : plan.getSplitSources().values()) {
            try {
                source.close();
            }
            catch (Throwable t) {
                log.warn(t, "Error closing split source");
            }
        }
        for (StageExecutionPlan stage : plan.getSubStages()) {
            SqlQueryExecution.closeSplitSources(stage);
        }
    }

    @Override
    public void cancelQuery() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void cancelStage(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQueryScheduler scheduler = this.queryScheduler.get();
            if (scheduler != null) {
                scheduler.cancelStage(stageId);
            }
        }
    }

    @Override
    public void fail(Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.stateMachine.transitionToFailed(cause);
    }

    @Override
    public boolean isDone() {
        return this.getState().isDone();
    }

    @Override
    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
        this.stateMachine.addOutputInfoListener(listener);
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.stateMachine.getStateChange(currentState);
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
        this.stateMachine.pruneQueryInfo();
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQueryScheduler scheduler = this.queryScheduler.get();
            QueryInfo queryInfo = this.stateMachine.getFinalQueryInfo().orElseGet(() -> this.buildQueryInfo(scheduler));
            return queryInfo;
        }
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    @Override
    public Plan getQueryPlan() {
        return this.queryPlan.get();
    }

    private QueryInfo buildQueryInfo(SqlQueryScheduler scheduler) {
        QueryInfo queryInfo;
        Optional<StageInfo> stageInfo = Optional.empty();
        if (scheduler != null) {
            stageInfo = Optional.ofNullable(scheduler.getStageInfo());
        }
        if ((queryInfo = this.stateMachine.updateQueryInfo(stageInfo)).isFinalQueryInfo()) {
            this.queryScheduler.set(null);
        }
        return queryInfo;
    }

    @Override
    public boolean shouldWaitForMinWorkers() {
        return this.shouldWaitForMinWorkers(this.analysis.getStatement());
    }

    private boolean shouldWaitForMinWorkers(Statement statement) {
        if (statement instanceof Query) {
            Collection<TableHandle> tables = this.analysis.getTables();
            return !tables.stream().map(TableHandle::getCatalogName).allMatch(CatalogName::isInternalSystemConnector);
        }
        return true;
    }

    public static class SqlQueryExecutionFactory
    implements QueryExecution.QueryExecutionFactory<QueryExecution> {
        private final SplitSchedulerStats schedulerStats;
        private final int scheduleSplitBatchSize;
        private final Metadata metadata;
        private final TypeOperators typeOperators;
        private final GroupProvider groupProvider;
        private final AccessControl accessControl;
        private final SqlParser sqlParser;
        private final SplitManager splitManager;
        private final NodePartitioningManager nodePartitioningManager;
        private final NodeScheduler nodeScheduler;
        private final List<PlanOptimizer> planOptimizers;
        private final PlanFragmenter planFragmenter;
        private final RemoteTaskFactory remoteTaskFactory;
        private final QueryExplainer queryExplainer;
        private final ExecutorService queryExecutor;
        private final ScheduledExecutorService schedulerExecutor;
        private final FailureDetector failureDetector;
        private final NodeTaskMap nodeTaskMap;
        private final Map<String, ExecutionPolicy> executionPolicies;
        private final StatsCalculator statsCalculator;
        private final CostCalculator costCalculator;
        private final DynamicFilterService dynamicFilterService;

        @Inject
        SqlQueryExecutionFactory(QueryManagerConfig config, Metadata metadata, TypeOperators typeOperators, GroupProvider groupProvider, AccessControl accessControl, SqlParser sqlParser, SplitManager splitManager, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, PlanOptimizersFactory planOptimizersFactory, PlanFragmenter planFragmenter, RemoteTaskFactory remoteTaskFactory, @ForQueryExecution ExecutorService queryExecutor, @ForScheduler ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, NodeTaskMap nodeTaskMap, QueryExplainer queryExplainer, Map<String, ExecutionPolicy> executionPolicies, SplitSchedulerStats schedulerStats, StatsCalculator statsCalculator, CostCalculator costCalculator, DynamicFilterService dynamicFilterService) {
            Objects.requireNonNull(config, "config is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.scheduleSplitBatchSize = config.getScheduleSplitBatchSize();
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
            this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
            this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
            this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
            this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
            this.schedulerExecutor = Objects.requireNonNull(schedulerExecutor, "schedulerExecutor is null");
            this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
            this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.executionPolicies = Objects.requireNonNull(executionPolicies, "executionPolicies is null");
            this.planOptimizers = Objects.requireNonNull(planOptimizersFactory, "planOptimizersFactory is null").get();
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
            this.dynamicFilterService = Objects.requireNonNull(dynamicFilterService, "dynamicFilterService is null");
        }

        @Override
        public QueryExecution createQueryExecution(QueryPreparer.PreparedQuery preparedQuery, QueryStateMachine stateMachine, Slug slug, WarningCollector warningCollector) {
            String executionPolicyName = SystemSessionProperties.getExecutionPolicy(stateMachine.getSession());
            ExecutionPolicy executionPolicy = this.executionPolicies.get(executionPolicyName);
            Preconditions.checkArgument((executionPolicy != null ? 1 : 0) != 0, (String)"No execution policy %s", (Object)executionPolicyName);
            return new SqlQueryExecution(preparedQuery, stateMachine, slug, this.metadata, this.typeOperators, this.groupProvider, this.accessControl, this.sqlParser, this.splitManager, this.nodePartitioningManager, this.nodeScheduler, this.planOptimizers, this.planFragmenter, this.remoteTaskFactory, this.scheduleSplitBatchSize, this.queryExecutor, this.schedulerExecutor, this.failureDetector, this.nodeTaskMap, this.queryExplainer, executionPolicy, this.schedulerStats, this.statsCalculator, this.costCalculator, this.dynamicFilterService, warningCollector);
        }
    }

    private static class PlanRoot {
        private final SubPlan root;
        private final boolean summarizeTaskInfos;

        public PlanRoot(SubPlan root, boolean summarizeTaskInfos) {
            this.root = Objects.requireNonNull(root, "root is null");
            this.summarizeTaskInfos = summarizeTaskInfos;
        }

        public SubPlan getRoot() {
            return this.root;
        }

        public boolean isSummarizeTaskInfos() {
            return this.summarizeTaskInfos;
        }
    }
}

