/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CatalogMetadata {
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final CatalogName catalogName;
    private final ConnectorMetadata metadata;
    private final ConnectorTransactionHandle transactionHandle;
    private final CatalogName informationSchemaId;
    private final ConnectorMetadata informationSchema;
    private final ConnectorTransactionHandle informationSchemaTransactionHandle;
    private final CatalogName systemTablesId;
    private final ConnectorMetadata systemTables;
    private final ConnectorTransactionHandle systemTablesTransactionHandle;
    private final Set<ConnectorCapabilities> connectorCapabilities;

    public CatalogMetadata(CatalogName catalogName, ConnectorMetadata metadata, ConnectorTransactionHandle transactionHandle, CatalogName informationSchemaId, ConnectorMetadata informationSchema, ConnectorTransactionHandle informationSchemaTransactionHandle, CatalogName systemTablesId, ConnectorMetadata systemTables, ConnectorTransactionHandle systemTablesTransactionHandle, Set<ConnectorCapabilities> connectorCapabilities) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        this.informationSchemaId = Objects.requireNonNull(informationSchemaId, "informationSchemaId is null");
        this.informationSchema = Objects.requireNonNull(informationSchema, "informationSchema is null");
        this.informationSchemaTransactionHandle = Objects.requireNonNull(informationSchemaTransactionHandle, "informationSchemaTransactionHandle is null");
        this.systemTablesId = Objects.requireNonNull(systemTablesId, "systemTablesId is null");
        this.systemTables = Objects.requireNonNull(systemTables, "systemTables is null");
        this.systemTablesTransactionHandle = Objects.requireNonNull(systemTablesTransactionHandle, "systemTablesTransactionHandle is null");
        this.connectorCapabilities = Sets.immutableEnumSet((Iterable)Objects.requireNonNull(connectorCapabilities, "connectorCapabilities is null"));
    }

    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    public ConnectorMetadata getMetadata() {
        return this.metadata;
    }

    public ConnectorMetadata getMetadataFor(CatalogName catalogName) {
        if (catalogName.equals(this.catalogName)) {
            return this.metadata;
        }
        if (catalogName.equals(this.informationSchemaId)) {
            return this.informationSchema;
        }
        if (catalogName.equals(this.systemTablesId)) {
            return this.systemTables;
        }
        throw new IllegalArgumentException("Unknown connector id: " + catalogName);
    }

    public ConnectorTransactionHandle getTransactionHandleFor(CatalogName catalogName) {
        if (catalogName.equals(this.catalogName)) {
            return this.transactionHandle;
        }
        if (catalogName.equals(this.informationSchemaId)) {
            return this.informationSchemaTransactionHandle;
        }
        if (catalogName.equals(this.systemTablesId)) {
            return this.systemTablesTransactionHandle;
        }
        throw new IllegalArgumentException("Unknown connector id: " + catalogName);
    }

    public CatalogName getConnectorIdForSchema(CatalogSchemaName schema) {
        if (schema.getSchemaName().equals(INFORMATION_SCHEMA_NAME)) {
            return this.informationSchemaId;
        }
        return this.catalogName;
    }

    public CatalogName getConnectorId(Session session, QualifiedObjectName table) {
        if (table.getSchemaName().equals(INFORMATION_SCHEMA_NAME)) {
            return this.informationSchemaId;
        }
        if (this.systemTables.getTableHandle(session.toConnectorSession(this.systemTablesId), table.asSchemaTableName()) != null) {
            return this.systemTablesId;
        }
        return this.catalogName;
    }

    public List<CatalogName> listConnectorIds() {
        return ImmutableList.of((Object)this.informationSchemaId, (Object)this.systemTablesId, (Object)this.catalogName);
    }

    public Set<ConnectorCapabilities> getConnectorCapabilities() {
        return this.connectorCapabilities;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).toString();
    }
}

