/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import io.trino.connector.informationschema.InformationSchemaHandleResolver;
import io.trino.connector.system.SystemHandleResolver;
import io.trino.metadata.RemoteHandleResolver;
import io.trino.operator.ExchangeOperator;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorHandleResolver;
import io.trino.spi.connector.ConnectorIndexHandle;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayoutHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.split.EmptySplitHandleResolver;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;

public final class HandleResolver {
    private final ConcurrentMap<String, MaterializedHandleResolver> handleResolvers = new ConcurrentHashMap<String, MaterializedHandleResolver>();

    @Inject
    public HandleResolver() {
        this.addCatalogHandleResolver(ExchangeOperator.REMOTE_CONNECTOR_ID.toString(), new RemoteHandleResolver());
        this.addCatalogHandleResolver("$system", new SystemHandleResolver());
        this.addCatalogHandleResolver("$info_schema", new InformationSchemaHandleResolver());
        this.addCatalogHandleResolver("$empty", new EmptySplitHandleResolver());
    }

    public void addCatalogHandleResolver(String catalogName, ConnectorHandleResolver resolver) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(resolver, "resolver is null");
        MaterializedHandleResolver existingResolver = this.handleResolvers.putIfAbsent(catalogName, new MaterializedHandleResolver(resolver));
        Preconditions.checkState((existingResolver == null ? 1 : 0) != 0, (String)"Catalog '%s' is already assigned to resolver: %s", (Object)catalogName, (Object)existingResolver);
    }

    public void removeCatalogHandleResolver(String catalogName) {
        this.handleResolvers.remove(catalogName);
    }

    public String getId(ConnectorTableHandle tableHandle) {
        return this.getId(tableHandle, MaterializedHandleResolver::getTableHandleClass);
    }

    public String getId(ConnectorTableLayoutHandle handle) {
        return this.getId(handle, MaterializedHandleResolver::getTableLayoutHandleClass);
    }

    public String getId(ColumnHandle columnHandle) {
        return this.getId(columnHandle, MaterializedHandleResolver::getColumnHandleClass);
    }

    public String getId(ConnectorSplit split) {
        return this.getId(split, MaterializedHandleResolver::getSplitClass);
    }

    public String getId(ConnectorIndexHandle indexHandle) {
        return this.getId(indexHandle, MaterializedHandleResolver::getIndexHandleClass);
    }

    public String getId(ConnectorOutputTableHandle outputHandle) {
        return this.getId(outputHandle, MaterializedHandleResolver::getOutputTableHandleClass);
    }

    public String getId(ConnectorInsertTableHandle insertHandle) {
        return this.getId(insertHandle, MaterializedHandleResolver::getInsertTableHandleClass);
    }

    public String getId(ConnectorPartitioningHandle partitioningHandle) {
        return this.getId(partitioningHandle, MaterializedHandleResolver::getPartitioningHandleClass);
    }

    public String getId(ConnectorTransactionHandle transactionHandle) {
        return this.getId(transactionHandle, MaterializedHandleResolver::getTransactionHandleClass);
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass(String id) {
        return this.resolverFor(id).getTableHandleClass().orElseThrow(() -> new IllegalArgumentException("No resolver for " + id));
    }

    public Class<? extends ConnectorTableLayoutHandle> getTableLayoutHandleClass(String id) {
        return this.resolverFor(id).getTableLayoutHandleClass().orElseThrow(() -> new IllegalArgumentException("No resolver for " + id));
    }

    public Class<? extends ColumnHandle> getColumnHandleClass(String id) {
        return this.resolverFor(id).getColumnHandleClass().orElseThrow(() -> new IllegalArgumentException("No resolver for " + id));
    }

    public Class<? extends ConnectorSplit> getSplitClass(String id) {
        return this.resolverFor(id).getSplitClass().orElseThrow(() -> new IllegalArgumentException("No resolver for " + id));
    }

    public Class<? extends ConnectorIndexHandle> getIndexHandleClass(String id) {
        return this.resolverFor(id).getIndexHandleClass().orElseThrow(() -> new IllegalArgumentException("No resolver for " + id));
    }

    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass(String id) {
        return this.resolverFor(id).getOutputTableHandleClass().orElseThrow(() -> new IllegalArgumentException("No resolver for " + id));
    }

    public Class<? extends ConnectorInsertTableHandle> getInsertTableHandleClass(String id) {
        return this.resolverFor(id).getInsertTableHandleClass().orElseThrow(() -> new IllegalArgumentException("No resolver for " + id));
    }

    public Class<? extends ConnectorPartitioningHandle> getPartitioningHandleClass(String id) {
        return this.resolverFor(id).getPartitioningHandleClass().orElseThrow(() -> new IllegalArgumentException("No resolver for " + id));
    }

    public Class<? extends ConnectorTransactionHandle> getTransactionHandleClass(String id) {
        return this.resolverFor(id).getTransactionHandleClass().orElseThrow(() -> new IllegalArgumentException("No resolver for " + id));
    }

    private MaterializedHandleResolver resolverFor(String id) {
        MaterializedHandleResolver resolver = (MaterializedHandleResolver)this.handleResolvers.get(id);
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"No handle resolver for connector: %s", (Object)id);
        return resolver;
    }

    private <T> String getId(T handle, Function<MaterializedHandleResolver, Optional<Class<? extends T>>> getter) {
        for (Map.Entry entry : this.handleResolvers.entrySet()) {
            try {
                if (!getter.apply((MaterializedHandleResolver)entry.getValue()).map(clazz -> clazz.isInstance(handle)).orElse(false).booleanValue()) continue;
                return (String)entry.getKey();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        throw new IllegalArgumentException("No connector for handle: " + handle);
    }

    private static class MaterializedHandleResolver {
        private final Optional<Class<? extends ConnectorTableHandle>> tableHandle = MaterializedHandleResolver.getHandleClass(() -> ((ConnectorHandleResolver)resolver).getTableHandleClass());
        private final Optional<Class<? extends ConnectorTableLayoutHandle>> layoutHandle = MaterializedHandleResolver.getHandleClass(() -> ((ConnectorHandleResolver)resolver).getTableLayoutHandleClass());
        private final Optional<Class<? extends ColumnHandle>> columnHandle = MaterializedHandleResolver.getHandleClass(() -> ((ConnectorHandleResolver)resolver).getColumnHandleClass());
        private final Optional<Class<? extends ConnectorSplit>> split = MaterializedHandleResolver.getHandleClass(() -> ((ConnectorHandleResolver)resolver).getSplitClass());
        private final Optional<Class<? extends ConnectorIndexHandle>> indexHandle = MaterializedHandleResolver.getHandleClass(() -> ((ConnectorHandleResolver)resolver).getIndexHandleClass());
        private final Optional<Class<? extends ConnectorOutputTableHandle>> outputTableHandle = MaterializedHandleResolver.getHandleClass(() -> ((ConnectorHandleResolver)resolver).getOutputTableHandleClass());
        private final Optional<Class<? extends ConnectorInsertTableHandle>> insertTableHandle = MaterializedHandleResolver.getHandleClass(() -> ((ConnectorHandleResolver)resolver).getInsertTableHandleClass());
        private final Optional<Class<? extends ConnectorPartitioningHandle>> partitioningHandle = MaterializedHandleResolver.getHandleClass(() -> ((ConnectorHandleResolver)resolver).getPartitioningHandleClass());
        private final Optional<Class<? extends ConnectorTransactionHandle>> transactionHandle = MaterializedHandleResolver.getHandleClass(() -> ((ConnectorHandleResolver)resolver).getTransactionHandleClass());

        public MaterializedHandleResolver(ConnectorHandleResolver resolver) {
        }

        private static <T> Optional<Class<? extends T>> getHandleClass(Supplier<Class<? extends T>> callable) {
            try {
                return Optional.of(callable.get());
            }
            catch (UnsupportedOperationException e) {
                return Optional.empty();
            }
        }

        public Optional<Class<? extends ConnectorTableHandle>> getTableHandleClass() {
            return this.tableHandle;
        }

        public Optional<Class<? extends ConnectorTableLayoutHandle>> getTableLayoutHandleClass() {
            return this.layoutHandle;
        }

        public Optional<Class<? extends ColumnHandle>> getColumnHandleClass() {
            return this.columnHandle;
        }

        public Optional<Class<? extends ConnectorSplit>> getSplitClass() {
            return this.split;
        }

        public Optional<Class<? extends ConnectorIndexHandle>> getIndexHandleClass() {
            return this.indexHandle;
        }

        public Optional<Class<? extends ConnectorOutputTableHandle>> getOutputTableHandleClass() {
            return this.outputTableHandle;
        }

        public Optional<Class<? extends ConnectorInsertTableHandle>> getInsertTableHandleClass() {
            return this.insertTableHandle;
        }

        public Optional<Class<? extends ConnectorPartitioningHandle>> getPartitioningHandleClass() {
            return this.partitioningHandle;
        }

        public Optional<Class<? extends ConnectorTransactionHandle>> getTransactionHandleClass() {
            return this.transactionHandle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MaterializedHandleResolver that = (MaterializedHandleResolver)o;
            return Objects.equals(this.tableHandle, that.tableHandle) && Objects.equals(this.layoutHandle, that.layoutHandle) && Objects.equals(this.columnHandle, that.columnHandle) && Objects.equals(this.split, that.split) && Objects.equals(this.indexHandle, that.indexHandle) && Objects.equals(this.outputTableHandle, that.outputTableHandle) && Objects.equals(this.insertTableHandle, that.insertTableHandle) && Objects.equals(this.partitioningHandle, that.partitioningHandle) && Objects.equals(this.transactionHandle, that.transactionHandle);
        }

        public int hashCode() {
            return Objects.hash(this.tableHandle, this.layoutHandle, this.columnHandle, this.split, this.indexHandle, this.outputTableHandle, this.insertTableHandle, this.partitioningHandle, this.transactionHandle);
        }
    }
}

