/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.Operator;
import io.trino.operator.WorkProcessor;
import io.trino.spi.Page;
import java.util.Objects;
import javax.annotation.Nullable;

public class PageBuffer {
    private final ListenableFuture<Void> initialFuture;
    @Nullable
    private Page page;
    private boolean finished;

    public PageBuffer() {
        this(Operator.NOT_BLOCKED);
    }

    public PageBuffer(ListenableFuture<Void> initialFuture) {
        this.initialFuture = initialFuture;
    }

    public WorkProcessor<Page> pages() {
        return WorkProcessor.create(() -> {
            if (this.isFinished() && this.isEmpty()) {
                return WorkProcessor.ProcessState.finished();
            }
            if (!this.initialFuture.isDone()) {
                return WorkProcessor.ProcessState.blocked(this.initialFuture);
            }
            if (!this.isEmpty()) {
                Page result = this.page;
                this.page = null;
                return WorkProcessor.ProcessState.ofResult(result);
            }
            return WorkProcessor.ProcessState.yield();
        });
    }

    public boolean isEmpty() {
        return this.page == null;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void add(Page page) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)"page buffer is not empty");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"page buffer is finished");
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        this.page = page;
    }

    public void finish() {
        this.finished = true;
    }
}

