/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.slice.Slice;
import io.trino.metadata.FunctionArgumentDefinition;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.AggregationUtils;
import io.trino.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongStateSerializer;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowStateSerializer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UnscaledDecimal128Arithmetic;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class DecimalSumAggregation
extends SqlAggregationFunction {
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)38, (int)0);
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)18, (int)0);
    public static final DecimalSumAggregation DECIMAL_SUM_AGGREGATION = new DecimalSumAggregation();
    private static final String NAME = "sum";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputShortDecimal", LongDecimalWithOverflowState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputLongDecimal", LongDecimalWithOverflowState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "outputLongDecimal", LongDecimalWithOverflowState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "combine", LongDecimalWithOverflowState.class, LongDecimalWithOverflowState.class);

    public DecimalSumAggregation() {
        super(new FunctionMetadata(new Signature(NAME, new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.numericParameter((long)38L), TypeSignatureParameter.typeVariable((String)"s")}), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")}))), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), false, true, "Calculates the sum over the input values", FunctionKind.AGGREGATE), true, false);
    }

    @Override
    public List<TypeSignature> getIntermediateTypes(FunctionBinding functionBinding) {
        return ImmutableList.of((Object)new LongDecimalWithOverflowAndLongStateSerializer().getSerializedType().getTypeSignature());
    }

    @Override
    public InternalAggregationFunction specialize(FunctionBinding functionBinding) {
        Type inputType = (Type)Iterables.getOnlyElement(functionBinding.getBoundSignature().getArgumentTypes());
        Type outputType = functionBinding.getBoundSignature().getReturnType();
        return DecimalSumAggregation.generateAggregation(inputType, outputType);
    }

    private static InternalAggregationFunction generateAggregation(Type inputType, Type outputType) {
        Preconditions.checkArgument((boolean)(inputType instanceof DecimalType), (Object)"type must be Decimal");
        DynamicClassLoader classLoader = new DynamicClassLoader(DecimalSumAggregation.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)inputType);
        Class<LongDecimalWithOverflowState> stateInterface = LongDecimalWithOverflowState.class;
        LongDecimalWithOverflowStateSerializer stateSerializer = new LongDecimalWithOverflowStateSerializer();
        MethodHandle inputFunction = ((DecimalType)inputType).isShort() ? SHORT_DECIMAL_INPUT_FUNCTION : LONG_DECIMAL_INPUT_FUNCTION;
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), DecimalSumAggregation.createInputParameterMetadata(inputType), inputFunction, Optional.empty(), COMBINE_FUNCTION, LONG_DECIMAL_OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, stateSerializer, new LongDecimalWithOverflowStateFactory())), outputType);
        Type intermediateType = stateSerializer.getSerializedType();
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), outputType, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void inputShortDecimal(LongDecimalWithOverflowState state, Block block, int position) {
        Slice sum = state.getLongDecimal();
        if (sum == null) {
            sum = UnscaledDecimal128Arithmetic.unscaledDecimal();
            state.setLongDecimal(sum);
        }
        long overflow = UnscaledDecimal128Arithmetic.addWithOverflow((Slice)sum, (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)SHORT_DECIMAL_TYPE.getLong(block, position)), (Slice)sum);
        state.addOverflow(overflow);
    }

    public static void inputLongDecimal(LongDecimalWithOverflowState state, Block block, int position) {
        Slice sum = state.getLongDecimal();
        if (sum == null) {
            sum = UnscaledDecimal128Arithmetic.unscaledDecimal();
            state.setLongDecimal(sum);
        }
        long overflow = UnscaledDecimal128Arithmetic.addWithOverflow((Slice)sum, (Slice)LONG_DECIMAL_TYPE.getSlice(block, position), (Slice)sum);
        state.addOverflow(overflow);
    }

    public static void combine(LongDecimalWithOverflowState state, LongDecimalWithOverflowState otherState) {
        Slice sum = state.getLongDecimal();
        long overflow = otherState.getOverflow();
        if (sum == null) {
            state.setLongDecimal(otherState.getLongDecimal());
        } else {
            overflow += UnscaledDecimal128Arithmetic.addWithOverflow((Slice)sum, (Slice)otherState.getLongDecimal(), (Slice)sum);
        }
        state.addOverflow(overflow);
    }

    public static void outputLongDecimal(LongDecimalWithOverflowState state, BlockBuilder out) {
        Slice decimal = state.getLongDecimal();
        if (decimal == null) {
            out.appendNull();
        } else {
            if (state.getOverflow() != 0L) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
            UnscaledDecimal128Arithmetic.throwIfOverflows((Slice)decimal);
            LONG_DECIMAL_TYPE.writeSlice(out, decimal);
        }
    }
}

