/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.Type;
import io.trino.type.BigintOperators;
import io.trino.type.IntervalYearMonthType;

@AggregationFunction(value="sum")
public final class IntervalYearToMonthSumAggregation {
    private IntervalYearToMonthSumAggregation() {
    }

    @InputFunction
    public static void sum(NullableLongState state, @SqlType(value="interval year to month") long value) {
        state.setNull(false);
        state.setLong(BigintOperators.add(state.getLong(), value));
    }

    @CombineFunction
    public static void combine(NullableLongState state, NullableLongState otherState) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(otherState.getLong());
            return;
        }
        state.setLong(BigintOperators.add(state.getLong(), otherState.getLong()));
    }

    @OutputFunction(value="interval year to month")
    public static void output(NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, state, out);
    }
}

