/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.histogram;

import com.google.common.base.Preconditions;
import io.trino.array.IntBigArray;
import io.trino.array.LongBigArray;
import io.trino.operator.aggregation.histogram.HashUtil;
import io.trino.operator.aggregation.histogram.HistogramValueReader;
import io.trino.operator.aggregation.histogram.TypedHistogram;
import io.trino.operator.aggregation.histogram.ValueStore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class GroupedTypedHistogram
implements TypedHistogram {
    private static final float MAX_FILL_RATIO = 0.5f;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedTypedHistogram.class).instanceSize();
    private static final int EMPTY_BUCKET = -1;
    private static final int NULL = -1;
    private final int bucketId;
    private final Type type;
    private final BlockTypeOperators.BlockPositionEqual equalOperator;
    private final BlockTypeOperators.BlockPositionHashCode hashCodeOperator;
    private final BlockBuilder values;
    private final BucketNodeFactory bucketNodeFactory;
    private final LongBigArray counts;
    private final LongBigArray groupIds;
    private final IntBigArray nextPointers;
    private final IntBigArray valuePositions;
    private final LongBigArray valueAndGroupHashes;
    private final LongBigArray headPointers;
    private IntBigArray buckets;
    private int nextNodePointer;
    private int mask;
    private int bucketCount;
    private int maxFill;
    private int currentGroupId = -1;
    private long numberOfGroups = 1L;
    private final ValueStore valueStore;

    public GroupedTypedHistogram(Type type, BlockTypeOperators.BlockPositionEqual equalOperator, BlockTypeOperators.BlockPositionHashCode hashCodeOperator, int expectedCount) {
        Preconditions.checkArgument((expectedCount > 0 ? 1 : 0) != 0, (Object)"expectedSize must be greater than zero");
        this.type = Objects.requireNonNull(type, "type is null");
        this.equalOperator = Objects.requireNonNull(equalOperator, "equalOperator is null");
        this.hashCodeOperator = Objects.requireNonNull(hashCodeOperator, "hashCodeOperator is null");
        this.bucketId = expectedCount;
        this.bucketCount = GroupedTypedHistogram.computeBucketCount(expectedCount, 0.5f);
        this.mask = this.bucketCount - 1;
        this.maxFill = HashUtil.calculateMaxFill(this.bucketCount, 0.5f);
        this.values = type.createBlockBuilder(null, GroupedTypedHistogram.computeBucketCount(expectedCount, 0.5f));
        this.buckets = new IntBigArray(-1);
        this.buckets.ensureCapacity((long)this.bucketCount);
        this.counts = new LongBigArray();
        this.valuePositions = new IntBigArray();
        this.valueAndGroupHashes = new LongBigArray();
        this.nextPointers = new IntBigArray(-1);
        this.groupIds = new LongBigArray(-1L);
        this.resizeNodeArrays(this.bucketCount);
        this.headPointers = new LongBigArray(-1L);
        this.nextNodePointer = 0;
        this.bucketNodeFactory = new BucketNodeFactory();
        this.valueStore = new ValueStore(type, equalOperator, expectedCount, this.values);
    }

    public GroupedTypedHistogram(long groupId, Block block, Type type, BlockTypeOperators.BlockPositionEqual equalOperator, BlockTypeOperators.BlockPositionHashCode hashCodeOperator, int bucketId) {
        this(type, equalOperator, hashCodeOperator, bucketId);
        this.currentGroupId = (int)groupId;
        Objects.requireNonNull(block, "block is null");
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            this.add(groupId, block, i, BigintType.BIGINT.getLong(block, i + 1));
        }
    }

    @Override
    public void ensureCapacity(long size) {
        long actualSize;
        this.numberOfGroups = actualSize = Math.max(this.numberOfGroups, size);
        this.headPointers.ensureCapacity(actualSize);
        this.valueAndGroupHashes.ensureCapacity(actualSize);
    }

    @Override
    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.counts.sizeOf() + this.groupIds.sizeOf() + this.nextPointers.sizeOf() + this.valuePositions.sizeOf() + this.valueAndGroupHashes.sizeOf() + this.buckets.sizeOf() + this.values.getRetainedSizeInBytes() + this.valueStore.getEstimatedSize() + this.headPointers.sizeOf();
    }

    @Override
    public void serialize(BlockBuilder out) {
        if (this.isCurrentGroupEmpty()) {
            out.appendNull();
        } else {
            BlockBuilder blockBuilder = out.beginBlockEntry();
            this.iterateGroupNodes(this.currentGroupId, nodePointer -> {
                Preconditions.checkArgument((nodePointer != -1 ? 1 : 0) != 0, (Object)"should never see null here as we exclude in iterateGroupNodesCall");
                ValueNode valueNode = this.bucketNodeFactory.createValueNode(nodePointer);
                valueNode.writeNodeAsBlock((Block)this.values, blockBuilder);
            });
            out.closeEntry();
        }
    }

    @Override
    public void addAll(TypedHistogram other) {
        this.addAll(this.currentGroupId, other);
    }

    @Override
    public void readAllValues(HistogramValueReader reader) {
        this.iterateGroupNodes(this.currentGroupId, nodePointer -> {
            Preconditions.checkArgument((nodePointer != -1 ? 1 : 0) != 0, (Object)"should never see null here as we exclude in iterateGroupNodesCall");
            ValueNode valueNode = this.bucketNodeFactory.createValueNode(nodePointer);
            reader.read((Block)this.values, valueNode.getValuePosition(), valueNode.getCount());
        });
    }

    @Override
    public TypedHistogram setGroupId(long groupId) {
        this.currentGroupId = (int)groupId;
        return this;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getExpectedSize() {
        return this.bucketId;
    }

    @Override
    public boolean isEmpty() {
        return this.isCurrentGroupEmpty();
    }

    @Override
    public void add(int position, Block block, long count) {
        Preconditions.checkState((this.currentGroupId != -1 ? 1 : 0) != 0, (Object)"setGroupId() not called yet");
        this.add(this.currentGroupId, block, position, count);
    }

    private void resizeTableIfNecessary() {
        if (this.nextNodePointer >= this.maxFill) {
            this.rehash();
        }
    }

    private static int computeBucketCount(int expectedSize, float maxFillRatio) {
        return HashCommon.arraySize((int)expectedSize, (float)maxFillRatio);
    }

    private void addAll(long groupId, TypedHistogram other) {
        other.readAllValues((block, position, count) -> this.add(groupId, block, position, count));
    }

    private void add(long groupId, Block block, int position, long count) {
        this.resizeTableIfNecessary();
        BucketDataNode bucketDataNode = this.bucketNodeFactory.createBucketDataNode(groupId, block, position);
        if (bucketDataNode.processEntry(groupId, block, position, count)) {
            ++this.nextNodePointer;
        }
    }

    private boolean isCurrentGroupEmpty() {
        return this.headPointers.get((long)this.currentGroupId) == -1L;
    }

    private void iterateGroupNodes(long groupdId, NodeReader nodeReader) {
        int currentPointer = (int)this.headPointers.get(groupdId);
        Preconditions.checkArgument((currentPointer != -1 ? 1 : 0) != 0, (Object)"valid group must have non-null head pointer");
        while (currentPointer != -1) {
            Preconditions.checkState((currentPointer < this.nextNodePointer ? 1 : 0) != 0, (String)"error, corrupt pointer; max valid %s, found %s", (int)this.nextNodePointer, (int)currentPointer);
            nodeReader.read(currentPointer);
            currentPointer = this.nextPointers.get((long)currentPointer);
        }
    }

    private void rehash() {
        long newBucketCountLong = (long)this.bucketCount * 2L;
        if (newBucketCountLong > Integer.MAX_VALUE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 2147483647 entries (" + newBucketCountLong + ")");
        }
        int newBucketCount = GroupedTypedHistogram.computeBucketCount((int)newBucketCountLong, 0.5f);
        int newMask = newBucketCount - 1;
        IntBigArray newBuckets = new IntBigArray(-1);
        newBuckets.ensureCapacity((long)newBucketCount);
        for (int i = 0; i < this.nextNodePointer; ++i) {
            int bucketId = this.getBucketIdForNode(i, newMask);
            int probeCount = 1;
            int originalBucket = bucketId;
            while (newBuckets.get((long)bucketId) != -1) {
                int probe = this.nextProbe(probeCount);
                bucketId = HashUtil.nextBucketId(originalBucket, newMask, probe);
                ++probeCount;
            }
            newBuckets.set((long)bucketId, i);
        }
        this.buckets = newBuckets;
        this.bucketCount = newBucketCount;
        this.maxFill = HashUtil.calculateMaxFill(newBucketCount, 0.5f);
        this.mask = newMask;
        this.resizeNodeArrays(newBucketCount);
    }

    private int nextProbe(int probeCount) {
        return HashUtil.nextProbeLinear(probeCount);
    }

    private void resizeNodeArrays(int newBucketCount) {
        this.counts.ensureCapacity((long)newBucketCount);
        this.valuePositions.ensureCapacity((long)newBucketCount);
        this.nextPointers.ensureCapacity((long)newBucketCount);
        this.valueAndGroupHashes.ensureCapacity((long)newBucketCount);
        this.groupIds.ensureCapacity((long)newBucketCount);
    }

    private long combineGroupAndValueHash(long groupIdHash, long valueHash) {
        return groupIdHash ^ valueHash;
    }

    private int getBucketIdForNode(int nodePointer, int mask) {
        long valueAndGroupHash = this.valueAndGroupHashes.get((long)nodePointer);
        int bucketId = (int)(valueAndGroupHash & (long)mask);
        return bucketId;
    }

    private static interface NodeReader {
        public void read(int var1);
    }

    private class BucketNodeFactory {
        private BucketNodeFactory() {
        }

        private BucketDataNode createBucketDataNode(long groupId, Block block, int position) {
            long valueHash = HashCommon.murmurHash3((long)GroupedTypedHistogram.this.hashCodeOperator.hashCodeNullSafe(block, position));
            long groupIdHash = HashCommon.murmurHash3((long)groupId);
            long valueAndGroupHash = GroupedTypedHistogram.this.combineGroupAndValueHash(groupIdHash, valueHash);
            int bucketId = (int)(valueAndGroupHash & (long)GroupedTypedHistogram.this.mask);
            int probeCount = 1;
            int originalBucketId = bucketId;
            int nodePointer;
            while ((nodePointer = GroupedTypedHistogram.this.buckets.get((long)bucketId)) != -1) {
                if (this.groupAndValueMatches(groupId, block, position, nodePointer, GroupedTypedHistogram.this.valuePositions.get((long)nodePointer))) {
                    return new BucketDataNode(bucketId, new ValueNode(nodePointer), valueHash, valueAndGroupHash, nodePointer, false);
                }
                int probe = GroupedTypedHistogram.this.nextProbe(probeCount);
                bucketId = HashUtil.nextBucketId(originalBucketId, GroupedTypedHistogram.this.mask, probe);
                ++probeCount;
            }
            return new BucketDataNode(bucketId, new ValueNode(GroupedTypedHistogram.this.nextNodePointer), valueHash, valueAndGroupHash, GroupedTypedHistogram.this.nextNodePointer, true);
        }

        private boolean groupAndValueMatches(long groupId, Block block, int position, int nodePointer, int valuePosition) {
            long existingGroupId = GroupedTypedHistogram.this.groupIds.get((long)nodePointer);
            return existingGroupId == groupId && GroupedTypedHistogram.this.equalOperator.equal(block, position, (Block)GroupedTypedHistogram.this.values, valuePosition) != false;
        }

        private ValueNode createValueNode(int nodePointer) {
            return new ValueNode(nodePointer);
        }
    }

    private class BucketDataNode {
        private final int bucketId;
        private final ValueNode valueNode;
        private final long valueHash;
        private final long valueAndGroupHash;
        private final int nodePointerToUse;
        private final boolean isEmpty;

        private BucketDataNode(int bucketId, ValueNode valueNode, long valueHash, long valueAndGroupHash, int nodePointerToUse, boolean isEmpty) {
            this.bucketId = bucketId;
            this.valueNode = valueNode;
            this.valueHash = valueHash;
            this.valueAndGroupHash = valueAndGroupHash;
            this.nodePointerToUse = nodePointerToUse;
            this.isEmpty = isEmpty;
        }

        private boolean isEmpty() {
            return this.isEmpty;
        }

        private boolean processEntry(long groupId, Block block, int position, long count) {
            if (this.isEmpty()) {
                this.addNewGroup(groupId, block, position, count);
                return true;
            }
            this.valueNode.add(count);
            return false;
        }

        private void addNewGroup(long groupId, Block block, int position, long count) {
            Preconditions.checkState((boolean)this.isEmpty(), (String)"bucket %s not empty, points to %s", (int)this.bucketId, (int)GroupedTypedHistogram.this.buckets.get((long)this.bucketId));
            int nextValuePosition = GroupedTypedHistogram.this.valueStore.addAndGetPosition(block, position, this.valueHash);
            GroupedTypedHistogram.this.valuePositions.set((long)this.nodePointerToUse, nextValuePosition);
            GroupedTypedHistogram.this.valueAndGroupHashes.set((long)this.nodePointerToUse, this.valueAndGroupHash);
            GroupedTypedHistogram.this.buckets.set((long)this.bucketId, this.nodePointerToUse);
            GroupedTypedHistogram.this.counts.set((long)this.nodePointerToUse, count);
            GroupedTypedHistogram.this.groupIds.set((long)this.nodePointerToUse, groupId);
            int currentHead = (int)GroupedTypedHistogram.this.headPointers.get(groupId);
            GroupedTypedHistogram.this.headPointers.set(groupId, (long)this.nodePointerToUse);
            GroupedTypedHistogram.this.nextPointers.set((long)this.nodePointerToUse, currentHead);
        }
    }

    private class ValueNode {
        private final int nodePointer;

        ValueNode(int nodePointer) {
            Preconditions.checkState((nodePointer > -1 ? 1 : 0) != 0, (Object)"ValueNode must point to a non-empty node");
            this.nodePointer = nodePointer;
        }

        long getCount() {
            return GroupedTypedHistogram.this.counts.get((long)this.nodePointer);
        }

        int getValuePosition() {
            return GroupedTypedHistogram.this.valuePositions.get((long)this.nodePointer);
        }

        void add(long count) {
            GroupedTypedHistogram.this.counts.add((long)this.nodePointer, count);
        }

        void writeNodeAsBlock(Block valuesBlock, BlockBuilder outputBlockBuilder) {
            GroupedTypedHistogram.this.type.appendTo(valuesBlock, this.getValuePosition(), outputBlockBuilder);
            BigintType.BIGINT.writeLong(outputBlockBuilder, this.getCount());
        }
    }
}

