/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;

public class LongDecimalWithOverflowStateSerializer
implements AccumulatorStateSerializer<LongDecimalWithOverflowState> {
    private static final int SERIALIZED_SIZE = 24;

    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(LongDecimalWithOverflowState state, BlockBuilder out) {
        Slice decimal = state.getLongDecimal();
        if (decimal == null) {
            out.appendNull();
        } else {
            long overflow = state.getOverflow();
            VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedLongArray((long[])new long[]{overflow, decimal.getLong(0), decimal.getLong(8)}));
        }
    }

    public void deserialize(Block block, int index, LongDecimalWithOverflowState state) {
        if (!block.isNull(index)) {
            Slice slice = VarbinaryType.VARBINARY.getSlice(block, index);
            if (slice.length() != 24) {
                throw new IllegalStateException("Unexpected serialized state size: " + slice.length());
            }
            long overflow = slice.getLong(0);
            Slice decimal = Slices.wrappedLongArray((long[])new long[]{slice.getLong(8), slice.getLong(16)});
            state.setOverflow(overflow);
            state.setLongDecimal(decimal);
        }
    }
}

