/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.annotations;

import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.SignatureBinder;
import io.trino.operator.annotations.ScalarImplementationDependency;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;

public final class FunctionImplementationDependency
extends ScalarImplementationDependency {
    private final QualifiedName name;
    private final List<TypeSignature> argumentTypes;

    public FunctionImplementationDependency(QualifiedName name, List<TypeSignature> argumentTypes, InvocationConvention invocationConvention, Class<?> type) {
        super(invocationConvention, type);
        this.name = Objects.requireNonNull(name, "name is null");
        this.argumentTypes = Objects.requireNonNull(argumentTypes, "argumentTypes is null");
    }

    @Override
    public void declareDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder) {
        builder.addFunctionSignature(this.name, this.argumentTypes);
    }

    @Override
    protected FunctionInvoker getInvoker(FunctionBinding functionBinding, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
        List<TypeSignature> types = SignatureBinder.applyBoundVariables(this.argumentTypes, functionBinding);
        return functionDependencies.getFunctionSignatureInvoker(this.name, types, invocationConvention);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionImplementationDependency that = (FunctionImplementationDependency)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.argumentTypes);
    }
}

