/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlOperator;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.JsonOperators;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.JsonType;
import io.trino.util.Failures;
import io.trino.util.JsonUtil;
import io.trino.util.Reflection;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ArrayToJsonCast
extends SqlOperator {
    public static final ArrayToJsonCast ARRAY_TO_JSON = new ArrayToJsonCast(false);
    public static final ArrayToJsonCast LEGACY_ARRAY_TO_JSON = new ArrayToJsonCast(true);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayToJsonCast.class, "toJson", JsonUtil.JsonGeneratorWriter.class, Block.class);
    private final boolean legacyRowToJson;

    private ArrayToJsonCast(boolean legacyRowToJson) {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.castableToTypeParameter("T", JsonType.JSON.getTypeSignature())), (List<LongVariableConstraint>)ImmutableList.of(), JsonType.JSON.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))), false);
        this.legacyRowToJson = legacyRowToJson;
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Preconditions.checkArgument((functionBinding.getArity() == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type type = functionBinding.getTypeVariable("T");
        Type arrayType = functionBinding.getBoundSignature().getArgumentTypes().get(0);
        Failures.checkCondition(JsonUtil.canCastToJson(arrayType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast %s to JSON", arrayType);
        JsonUtil.JsonGeneratorWriter writer = JsonUtil.JsonGeneratorWriter.createJsonGeneratorWriter(type, this.legacyRowToJson);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(writer);
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    public static Slice toJson(JsonUtil.JsonGeneratorWriter writer, Block block) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(40);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JsonOperators.JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeStartArray();
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    writer.writeJsonValue(jsonGenerator, block, i);
                }
                jsonGenerator.writeEndArray();
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

