/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlOperator;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.gen.CachedInstanceBinder;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.InvokeFunctionBytecodeExpression;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.type.UnknownType;
import io.trino.util.CompilerUtils;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class RowToRowCast
extends SqlOperator {
    public static final RowToRowCast ROW_TO_ROW_CAST = new RowToRowCast();

    private RowToRowCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)new TypeVariableConstraint("F", false, false, "row", (Set<TypeSignature>)ImmutableSet.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), (Set<TypeSignature>)ImmutableSet.of()), (Object)Signature.withVariadicBound("T", "row")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("T", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("F", new TypeSignatureParameter[0])), false);
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(FunctionBinding functionBinding) {
        List toTypes = functionBinding.getTypeVariable("T").getTypeParameters();
        List fromTypes = functionBinding.getTypeVariable("F").getTypeParameters();
        FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder = FunctionDependencyDeclaration.builder();
        for (int i = 0; i < toTypes.size(); ++i) {
            Type fromElementType = (Type)fromTypes.get(i);
            Type toElementType = (Type)toTypes.get(i);
            builder.addCast(fromElementType, toElementType);
        }
        return builder.build();
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        Preconditions.checkArgument((functionBinding.getArity() == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type fromType = functionBinding.getTypeVariable("F");
        Type toType = functionBinding.getTypeVariable("T");
        if (fromType.getTypeParameters().size() != toType.getTypeParameters().size()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "the size of fromType and toType must match");
        }
        Class<?> castOperatorClass = RowToRowCast.generateRowCast(fromType, toType, functionDependencies);
        MethodHandle methodHandle = Reflection.methodHandle(castOperatorClass, "castRow", ConnectorSession.class, Block.class);
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    private static Class<?> generateRowCast(Type fromType, Type toType, FunctionDependencies functionDependencies) {
        List toTypes = toType.getTypeParameters();
        List fromTypes = fromType.getTypeParameters();
        CallSiteBinder binder = new CallSiteBinder();
        byte[] md5Suffix = Hashing.md5().hashBytes((fromType + "$" + toType).getBytes(StandardCharsets.UTF_8)).asBytes();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(Joiner.on((String)"$").join((Object)"RowCast", (Object)BaseEncoding.base16().encode(md5Suffix), new Object[0])), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter value = Parameter.arg((String)"value", Block.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "castRow", ParameterizedType.type(Block.class), new Parameter[]{session, value});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        Variable blockBuilder = scope.createTempVariable(BlockBuilder.class);
        Variable singleRowBlockWriter = scope.createTempVariable(BlockBuilder.class);
        body.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantBoolean((boolean)false)));
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(definition, binder);
        body.append((BytecodeNode)blockBuilder.set(SqlTypeBytecodeExpression.constantType(binder, toType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), BytecodeExpressions.constantInt((int)1)})));
        body.append((BytecodeNode)singleRowBlockWriter.set(blockBuilder.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
        for (int i = 0; i < toTypes.size(); ++i) {
            Type fromElementType = (Type)fromTypes.get(i);
            Type toElementType = (Type)toTypes.get(i);
            FunctionMetadata castMetadata = functionDependencies.getCastMetadata(fromElementType, toElementType);
            Function<InvocationConvention, FunctionInvoker> castInvokerProvider = invocationConvention -> functionDependencies.getCastInvoker(fromElementType, toElementType, (InvocationConvention)invocationConvention);
            Type currentFromType = fromElementType;
            if (currentFromType.equals((Object)UnknownType.UNKNOWN)) {
                body.append((BytecodeNode)singleRowBlockWriter.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop());
                continue;
            }
            BytecodeExpression fromElement = SqlTypeBytecodeExpression.constantType(binder, currentFromType).getValue((BytecodeExpression)value, BytecodeExpressions.constantInt((int)i));
            BytecodeExpression toElement = InvokeFunctionBytecodeExpression.invokeFunction(scope, cachedInstanceBinder, toElementType, castMetadata, castInvokerProvider, fromElement);
            IfStatement ifElementNull = new IfStatement("if the element in the row type is null...", new Object[0]);
            ifElementNull.condition((BytecodeNode)value.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)})).ifTrue((BytecodeNode)singleRowBlockWriter.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, toElementType).writeValue((BytecodeExpression)singleRowBlockWriter, toElement));
            body.append((BytecodeNode)ifElementNull);
        }
        body.append((BytecodeNode)blockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop());
        body.append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, toType).invoke("getObject", Object.class, new BytecodeExpression[]{blockBuilder.cast(Block.class), BytecodeExpressions.constantInt((int)0)}).cast(Block.class).ret());
        MethodDefinition constructorDefinition = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), RowToRowCast.class.getClassLoader());
    }
}

