/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.operator.PagesHashStrategy;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexComparator;
import io.trino.operator.WindowOperator;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.Partitioner;
import io.trino.operator.window.PatternRecognitionPartition;
import io.trino.operator.window.WindowPartition;
import io.trino.operator.window.matcher.Matcher;
import io.trino.operator.window.pattern.LabelEvaluator;
import io.trino.operator.window.pattern.LogicalIndexNavigation;
import io.trino.operator.window.pattern.MeasureComputation;
import io.trino.spi.function.WindowFunction;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.SkipTo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PatternRecognitionPartitioner
implements Partitioner {
    private final List<MeasureComputation> measures;
    private final Optional<FrameInfo> commonBaseFrame;
    private final PatternRecognitionRelation.RowsPerMatch rowsPerMatch;
    private final Optional<LogicalIndexNavigation> skipToNavigation;
    private final SkipTo.Position skipToPosition;
    private final boolean initial;
    private final Matcher matcher;
    private final List<LabelEvaluator.Evaluation> labelEvaluations;

    public PatternRecognitionPartitioner(List<MeasureComputation> measures, Optional<FrameInfo> commonBaseFrame, PatternRecognitionRelation.RowsPerMatch rowsPerMatch, Optional<LogicalIndexNavigation> skipToNavigation, SkipTo.Position skipToPosition, boolean initial, Matcher matcher, List<LabelEvaluator.Evaluation> labelEvaluations) {
        Objects.requireNonNull(measures, "measures is null");
        Objects.requireNonNull(commonBaseFrame, "commonBaseFrame is null");
        Objects.requireNonNull(rowsPerMatch, "rowsPerMatch is null");
        Objects.requireNonNull(skipToNavigation, "skipToNavigation is null");
        Objects.requireNonNull(skipToPosition, "skipToPosition is null");
        Objects.requireNonNull(matcher, "matcher is null");
        Objects.requireNonNull(labelEvaluations, "labelEvaluations is null");
        this.measures = measures;
        this.commonBaseFrame = commonBaseFrame;
        this.rowsPerMatch = rowsPerMatch;
        this.skipToNavigation = skipToNavigation;
        this.skipToPosition = skipToPosition;
        this.initial = initial;
        this.matcher = matcher;
        this.labelEvaluations = labelEvaluations;
    }

    @Override
    public WindowPartition createPartition(PagesIndex pagesIndex, int partitionStart, int partitionEnd, int[] outputChannels, List<WindowFunction> windowFunctions, List<FrameInfo> frames, PagesHashStrategy peerGroupHashStrategy, Map<WindowOperator.FrameBoundKey, PagesIndexComparator> frameBoundComparators) {
        return new PatternRecognitionPartition(pagesIndex, partitionStart, partitionEnd, outputChannels, windowFunctions, peerGroupHashStrategy, this.measures, this.commonBaseFrame, this.rowsPerMatch, this.skipToNavigation, this.skipToPosition, this.initial, this.matcher, this.labelEvaluations);
    }
}

