/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import io.trino.operator.window.matcher.ArrayView;
import java.util.Arrays;

class Captures {
    private final int[][] captures;
    private final int[] usedSlots;
    private final int minSlotCount;
    private final int[][] labels;
    private final int[] usedLabelsSlots;
    private final int minLabelCount;

    public Captures(int threadCount, int slotCount, int labelCount) {
        this.captures = new int[threadCount][];
        this.usedSlots = new int[threadCount];
        this.minSlotCount = slotCount;
        this.labels = new int[threadCount][];
        this.usedLabelsSlots = new int[threadCount];
        this.minLabelCount = labelCount;
    }

    public void allocate(int threadId) {
        this.captures[threadId] = new int[this.minSlotCount];
        this.labels[threadId] = new int[this.minLabelCount];
    }

    public void save(int threadId, int value) {
        this.ensureCapturesCapacity(threadId);
        this.captures[threadId][this.usedSlots[threadId]] = value;
        int n = threadId;
        this.usedSlots[n] = this.usedSlots[n] + 1;
    }

    public void saveLabel(int threadId, int value) {
        this.ensureLabelsCapacity(threadId);
        this.labels[threadId][this.usedLabelsSlots[threadId]] = value;
        int n = threadId;
        this.usedLabelsSlots[n] = this.usedLabelsSlots[n] + 1;
    }

    public void copy(int parent, int child) {
        this.captures[child] = (int[])this.captures[parent].clone();
        this.usedSlots[child] = this.usedSlots[parent];
        this.labels[child] = (int[])this.labels[parent].clone();
        this.usedLabelsSlots[child] = this.usedLabelsSlots[parent];
    }

    public ArrayView getCaptures(int threadId) {
        return new ArrayView(this.captures[threadId], this.usedSlots[threadId]);
    }

    public ArrayView getLabels(int threadId) {
        return new ArrayView(this.labels[threadId], this.usedLabelsSlots[threadId]);
    }

    public void release(int threadId) {
        this.captures[threadId] = null;
        this.usedSlots[threadId] = 0;
        this.labels[threadId] = null;
        this.usedLabelsSlots[threadId] = 0;
    }

    private void ensureCapturesCapacity(int threadId) {
        if (this.usedSlots[threadId] < this.captures[threadId].length) {
            return;
        }
        this.captures[threadId] = Arrays.copyOf(this.captures[threadId], this.captures[threadId].length * 2);
    }

    private void ensureLabelsCapacity(int threadId) {
        if (this.usedLabelsSlots[threadId] < this.labels[threadId].length) {
            return;
        }
        this.labels[threadId] = Arrays.copyOf(this.labels[threadId], this.labels[threadId].length * 2);
    }
}

