/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.inject.Binder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.server.HttpsConfig;
import io.trino.server.InternalAuthenticationManager;
import io.trino.server.InternalCommunicationConfig;

public class InternalCommunicationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        InternalCommunicationConfig internalCommunicationConfig = (InternalCommunicationConfig)this.buildConfigObject(InternalCommunicationConfig.class);
        if (internalCommunicationConfig.isHttpsRequired() && internalCommunicationConfig.getKeyStorePath() == null && internalCommunicationConfig.getTrustStorePath() == null) {
            String sharedSecret = internalCommunicationConfig.getSharedSecret().orElseThrow(() -> new IllegalArgumentException("Internal shared secret must be set when internal HTTPS is enabled"));
            ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(HttpsConfig.class, config -> config.setAutomaticHttpsSharedSecret(sharedSecret));
            ConfigBinder.configBinder((Binder)binder).bindConfigGlobalDefaults(HttpClientConfig.class, config -> {
                config.setHttp2Enabled(internalCommunicationConfig.isHttp2Enabled());
                config.setAutomaticHttpsSharedSecret(sharedSecret);
            });
        } else {
            ConfigBinder.configBinder((Binder)binder).bindConfigGlobalDefaults(HttpClientConfig.class, config -> {
                config.setHttp2Enabled(internalCommunicationConfig.isHttp2Enabled());
                config.setKeyStorePath(internalCommunicationConfig.getKeyStorePath());
                config.setKeyStorePassword(internalCommunicationConfig.getKeyStorePassword());
                config.setTrustStorePath(internalCommunicationConfig.getTrustStorePath());
                config.setTrustStorePassword(internalCommunicationConfig.getTrustStorePassword());
                config.setAutomaticHttpsSharedSecret(null);
            });
        }
        binder.bind(InternalAuthenticationManager.class);
        HttpClientBinder.httpClientBinder((Binder)binder).bindGlobalFilter(InternalAuthenticationManager.class);
    }
}

