/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryState;
import io.trino.execution.resourcegroups.ResourceGroupManager;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlUtil;
import io.trino.server.BasicQueryInfo;
import io.trino.server.HttpRequestSessionContext;
import io.trino.server.ProtocolConfig;
import io.trino.server.QueryStateInfo;
import io.trino.server.security.ResourceSecurity;
import io.trino.spi.QueryId;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.GroupProvider;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

@Path(value="/v1/queryState")
public class QueryStateInfoResource {
    private final DispatchManager dispatchManager;
    private final ResourceGroupManager<?> resourceGroupManager;
    private final AccessControl accessControl;
    private final GroupProvider groupProvider;
    private final Optional<String> alternateHeaderName;

    @Inject
    public QueryStateInfoResource(DispatchManager dispatchManager, ResourceGroupManager<?> resourceGroupManager, AccessControl accessControl, GroupProvider groupProvider, ProtocolConfig protocolConfig) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.alternateHeaderName = protocolConfig.getAlternateHeaderName();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.AUTHENTICATED_USER)
    @GET
    @Produces(value={"application/json"})
    public List<QueryStateInfo> getQueryStateInfos(@QueryParam(value="user") String user, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        List queryInfos = this.dispatchManager.getQueries();
        queryInfos = AccessControlUtil.filterQueries(HttpRequestSessionContext.extractAuthorizedIdentity(servletRequest, httpHeaders, this.alternateHeaderName, this.accessControl, this.groupProvider), queryInfos, this.accessControl);
        if (!Strings.isNullOrEmpty((String)user)) {
            queryInfos = (List)queryInfos.stream().filter(queryInfo -> Pattern.matches(user, queryInfo.getSession().getUser())).collect(ImmutableList.toImmutableList());
        }
        return (List)queryInfos.stream().filter(queryInfo -> !queryInfo.getState().isDone()).map(this::getQueryStateInfo).collect(ImmutableList.toImmutableList());
    }

    private QueryStateInfo getQueryStateInfo(BasicQueryInfo queryInfo) {
        Optional<ResourceGroupId> groupId = queryInfo.getResourceGroupId();
        if (queryInfo.getState() == QueryState.QUEUED) {
            return QueryStateInfo.createQueuedQueryStateInfo(queryInfo, groupId, groupId.map(group -> this.resourceGroupManager.tryGetPathToRoot((ResourceGroupId)group).orElseThrow(() -> new IllegalStateException("Resource group not found: " + group))));
        }
        return QueryStateInfo.createQueryStateInfo(queryInfo, groupId);
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.AUTHENTICATED_USER)
    @GET
    @Path(value="{queryId}")
    @Produces(value={"application/json"})
    public QueryStateInfo getQueryStateInfo(@PathParam(value="queryId") String queryId, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) throws WebApplicationException {
        try {
            BasicQueryInfo queryInfo = this.dispatchManager.getQueryInfo(new QueryId(queryId));
            AccessControlUtil.checkCanViewQueryOwnedBy(HttpRequestSessionContext.extractAuthorizedIdentity(servletRequest, httpHeaders, this.alternateHeaderName, this.accessControl, this.groupProvider), queryInfo.getSession().getUser(), this.accessControl);
            return this.getQueryStateInfo(queryInfo);
        }
        catch (AccessDeniedException e) {
            throw new ForbiddenException();
        }
        catch (NoSuchElementException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }
}

