/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class ServerConfig {
    private boolean coordinator = true;
    private boolean includeExceptionInResponse = true;
    private Duration gracePeriod = new Duration(2.0, TimeUnit.MINUTES);
    private boolean queryResultsCompressionEnabled = true;
    private Optional<String> queryInfoUrlTemplate = Optional.empty();

    public boolean isCoordinator() {
        return this.coordinator;
    }

    @Config(value="coordinator")
    public ServerConfig setCoordinator(boolean coordinator) {
        this.coordinator = coordinator;
        return this;
    }

    public boolean isIncludeExceptionInResponse() {
        return this.includeExceptionInResponse;
    }

    @Config(value="http.include-exception-in-response")
    public ServerConfig setIncludeExceptionInResponse(boolean includeExceptionInResponse) {
        this.includeExceptionInResponse = includeExceptionInResponse;
        return this;
    }

    public Duration getGracePeriod() {
        return this.gracePeriod;
    }

    @Config(value="shutdown.grace-period")
    public ServerConfig setGracePeriod(Duration gracePeriod) {
        this.gracePeriod = gracePeriod;
        return this;
    }

    public boolean isQueryResultsCompressionEnabled() {
        return this.queryResultsCompressionEnabled;
    }

    @Config(value="query-results.compression-enabled")
    public ServerConfig setQueryResultsCompressionEnabled(boolean queryResultsCompressionEnabled) {
        this.queryResultsCompressionEnabled = queryResultsCompressionEnabled;
        return this;
    }

    @NotNull
    public Optional<String> getQueryInfoUrlTemplate() {
        return this.queryInfoUrlTemplate;
    }

    @Config(value="query.info-url-template")
    public ServerConfig setQueryInfoUrlTemplate(String queryInfoUrlTemplate) {
        this.queryInfoUrlTemplate = Optional.ofNullable(queryInfoUrlTemplate);
        return this;
    }
}

